package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.*;
import com.ejianc.business.jltest.margin.service.IAssessCashService;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeService;
import com.ejianc.business.jltest.margin.service.IInspiritLossService;
import com.ejianc.business.jltest.margin.vo.AssessCashVO;
import com.ejianc.business.jltest.margin.vo.InspiritLossDetailVO;
import com.ejianc.business.jltest.margin.vo.InspiritLossVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 激励/补亏分配详情
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("inspiritLoss")
public class InspiritLossController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi iEmployeeApi;
    @Autowired
    private IRoleApi roleApi;


    private static final String BILL_CODE = "INSPIRIT_LOSS";//此处需要根据实际修改

    @Autowired
    private IInspiritLossService service;
    @Autowired
    private IDirectEmployeeService directEmployeeService;
    @Autowired
    private IAssessCashService assessCashService;
    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InspiritLossVO> saveOrUpdate(@RequestBody InspiritLossVO saveOrUpdateVO) {
    	InspiritLossEntity entity = BeanMapper.map(saveOrUpdateVO, InspiritLossEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	InspiritLossVO vo = BeanMapper.map(entity, InspiritLossVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InspiritLossVO> queryDetail(Long id) {
    	InspiritLossEntity entity = service.selectById(id);
    	InspiritLossVO vo = BeanMapper.map(entity, InspiritLossVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryEmployeeDetail 查询直管详情
     * @param id
     */
    @RequestMapping(value = "/queryEmployeeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InspiritLossVO> queryEmployeeDetail(Long id) {

        DirectEmployeeEntity entity = directEmployeeService.selectById(id);
        List<DirectEmployeeDetailEntity> detailList = entity.getDetailList();
        InspiritLossVO inspiritLossVO = new InspiritLossVO();
        List<InspiritLossDetailEntity> inspiritLossDetailEntities = new ArrayList<>();
        for (DirectEmployeeDetailEntity detailEntity:detailList) {
            InspiritLossDetailEntity inspiritLossDetailEntity = new InspiritLossDetailEntity();
            inspiritLossDetailEntity.setDetailCode(entity.getBillCode());
            inspiritLossDetailEntity.setDetailId(entity.getId());
            inspiritLossDetailEntity.setDetailName(detailEntity.getEmployeeName());
            CommonResponse<EmployeeVO> employeeApiById = iEmployeeApi.getById(detailEntity.getEmployeeId());

            //设置角色信息
            CommonResponse<List<RoleVO>> listCommonResponse = roleApi.queryRoleByUserId(employeeApiById.getData().getUserId());
            if (ObjectUtils.isEmpty(listCommonResponse.getData())||listCommonResponse.getData().size()==0){
                logger.info("角色信息为空");

            }else {
                List<RoleVO> roles = listCommonResponse.getData();
                List<String> roleName = new ArrayList<>();
                for (RoleVO roleVO:roles) {
                    roleName.add(roleVO.getName());
                }
                String roleNames = ObjectUtils.getDisplayString(roleName);
                logger.info("角色名称"+roleNames.substring(1,roleNames.length()-2)+";");
                inspiritLossDetailEntity.setDetailRole(roleNames.substring(1,roleNames.length()-1));
            }


            inspiritLossDetailEntity.setDetailPhone(employeeApiById.getData().getMobilePhone());
            inspiritLossDetailEntity.setDetailPay(detailEntity.getMarginMny());
            inspiritLossDetailEntity.setDetailPayed(detailEntity.getMarginActual());
            inspiritLossDetailEntity.setDetailPercentage(detailEntity.getMarginRatio());
            inspiritLossDetailEntity.setMemo(detailEntity.getMemo());
            inspiritLossDetailEntities.add(inspiritLossDetailEntity);
        }
        inspiritLossVO.setInspiritLossDetailList(BeanMapper.mapList(inspiritLossDetailEntities, InspiritLossDetailVO.class));

        return CommonResponse.success("查询详情数据成功！", inspiritLossVO);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InspiritLossVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InspiritLossVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InspiritLossVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InspiritLossVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_name");
        fuzzyFields.add("cash_node");
        fuzzyFields.add("employee_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            //param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            //判断是否为当前登录组织
            if (param.getParams().get("orgId") != null) {
                if ( param.getParams().get("orgId").getValue().toString().equals("true")) {
                    CommonResponse<EmployeeVO> employee = iEmployeeApi.getById(InvocationInfoProxy.getUserid());
                    param.getParams().put("orgId", new Parameter(QueryParam.EQ, employee.getData().getOrgId()));
                } else {
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                    //param.getParams().remove("orgId");
                }
            }
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<InspiritLossEntity> page = service.queryPage(param,false);
        IPage<InspiritLossVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InspiritLossVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_name");
        fuzzyFields.add("cash_node");
        fuzzyFields.add("employee_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //判断是否为当前登录组织+
        if (param.getParams().get("orgId") != null) {
            if ( param.getParams().get("orgId").getValue().toString().equals("true")) {
                CommonResponse<EmployeeVO> employee = iEmployeeApi.getById(InvocationInfoProxy.getUserid());
                logger.info("orgId8888888"+employee.getData().getOrgId());

                param.getParams().put("orgId", new Parameter(QueryParam.EQ, employee.getData().getOrgId()));
            } else {
                param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

                //param.getParams().remove("orgId");
            }
        }
        List<InspiritLossEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InspiritLoss-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInspiritLossData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InspiritLossVO>> refInspiritLossData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InspiritLossEntity> page = service.queryPage(param,false);
        IPage<InspiritLossVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InspiritLossVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * @Description queryDetail 根据上有数据Id获取分配总金额
     * @param id
     */
    @RequestMapping(value = "/queryAssessMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryAssessMny(Long id) {
        //获取已经提交的分配金额
        QueryWrapper<InspiritLossEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("cash_id",id);
        queryWrapper.eq("dr",0);
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        List<Integer> state = new ArrayList<>();
        state.add(1);
        state.add(3);
        queryWrapper.in("bill_state",state);
        List<InspiritLossEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            BigDecimal reduce = list.stream().map(InspiritLossEntity::getIssueAssessMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("分配的总金额为："+reduce);
            return CommonResponse.success("查询详情数据成功！",reduce);
        }else {
            return CommonResponse.success("查询详情数据成功！",BigDecimal.ZERO);
        }


    }
}
