package com.ejianc.business.jltest.orgtest.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.service.impl.PlanbDetailServiceImpl;
import com.ejianc.business.jltest.orgtest.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.min;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.orgtest.service.IPlanbService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 安措费使用计划B
 *
 * @author generator
 */
@Controller
@RequestMapping("planb")
public class PlanbController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLAN-B";// 此处需要根据实际修改

    @Autowired
    private IPlanbService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISafeteambService safeteambService;

    @Autowired
    private  PlanbDetailServiceImpl planbDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanbVO> saveOrUpdate(@RequestBody PlanbVO saveOrUpdateVO) {

        return CommonResponse.success("保存或修改单据成功！", service.saveUpdate(saveOrUpdateVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanbVO> queryDetail(Long id) {
        PlanbEntity entity = service.selectById(id);
        PlanbVO vo = BeanMapper.map(entity, PlanbVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanbVO> vos) {
        service.removeByIdsRewrite(vos);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanbVO1>> queryList(@RequestBody QueryParam param) {

        // 获取当前 登陆人的 姓名
        String employeeName = sessionManager.getUserContext().getEmployeeName();

        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();
            // System.out.println("kkkkkkkkkkkkkkk :"+key);

            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();
            // System.out.println("vvvvvvvv:"+value1);
            if (key.equals("employeeName") && value1.equals("yes")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.EQ, employeeName));
            }
            if (key.equals("employeeName") && value1.equals("no")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.NE, employeeName));
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("safeteambId");
        fuzzyFields.add("planbName");
        fuzzyFields.add("planbMny");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        // 当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {// 移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {// pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        // 普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        // 项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                // 项目部
                departmentIds.add(org.getId());
            } else {
                // 普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

    /*     IPage<PlanbEntity> page = service.queryPage(param, false);
        IPage<PlanbVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanbVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    } */
        IPage<PlanbEntity> page = service.queryPage(param,false);
        IPage<PlanbVO1> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlanbVO1> resDatas = new ArrayList<>();
        List<Object> objects = new ArrayList<>();


        if(CollectionUtils.isNotEmpty(page.getRecords())){
            resDatas = BeanMapper.mapList(page.getRecords(), PlanbVO1.class);
            List<Long> ids = new ArrayList<>();
            Map<Long,Integer> map = new HashMap<>();
            if(CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper<PlanbDetailEntity> lambda = Wrappers.<PlanbDetailEntity>lambdaQuery();
            lambda.in(PlanbDetailEntity::getPlanbId,ids);
            List<PlanbDetailEntity> resList = planbDetailService.list(lambda);
            List<PlanbVO1> unsettleListVOList = BeanMapper.mapList(resList, PlanbVO1.class);
            if(CollectionUtils.isNotEmpty(unsettleListVOList)){
                unsettleListVOList.forEach(e->{
                    e.setBillState(map.get(e.getPlanbId()));
                    e.setCreateTime(e.getCreateTime());
                    e.setPlanbMny(e.getDetailPlanbMny());
                    e.setPlanbName(e.getDetailPlanbName());
                });

                resDatas.addAll(unsettleListVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }else{
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanbVO1.class));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        // 获取当前 登陆人的 姓名
        String employeeName = sessionManager.getUserContext().getEmployeeName();

        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();
            // System.out.println("kkkkkkkkkkkkkkk :"+key);

            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();
            // System.out.println("vvvvvvvv:"+value1);
            if (key.equals("employeeName") && value1.equals("yes")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.EQ, employeeName));
            }
            if (key.equals("employeeName") && value1.equals("no")) {
                param.getParams().put("employeeName", new Parameter(QueryParam.NE, employeeName));
            }
        }
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("safeteambId");
        fuzzyFields.add("planbName");
        fuzzyFields.add("planbMny");
        fuzzyFields.add("employeeName");
        Map<String, Parameter> params1 = param.getParams();
        Parameter parameter = new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid());

        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanbEntity> list = service.queryList(param);

        //获取到主表的id
        List<Long> collect = list.stream().map(PlanbEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<PlanbDetailEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(PlanbDetailEntity::getPlanbId,collect);
        List<PlanbDetailEntity> deatilList = planbDetailService.list(wrapper);

        PlanbEntity planbEntity = new PlanbEntity();
        for (PlanbDetailEntity planbDetailEntity : deatilList) {
            planbEntity.setOrgName(planbDetailEntity.getOrgName());
            planbEntity.setPlanbName(planbDetailEntity.getDetailPlanbName());
            planbEntity.setCreateTime(planbDetailEntity.getCreateTime());
            planbEntity.setPlanbMny(planbDetailEntity.getDetailPlanbMny());
            list.add(planbEntity);
        }

        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Planb-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlanbData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanbVO>> refPlanbData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanbEntity> page = service.queryPage(param, false);
        IPage<PlanbVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanbVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Planb-Detail-import.xlsx", "明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlanbDetailVO> successList = new ArrayList<>();
        List<PlanbDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                // 获取物资档案数据
//                List<String> materialCodeList = new ArrayList<>();
//                Map<String,MaterialVO> map = new HashMap<>();
//                for (int i = 1; i < result.size(); i++) {
//                    List<String> datas = result.get(i);
//                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
//                }
//                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
//                if(!materialRes.isSuccess()){
//                    return CommonResponse.error(materialRes.getMsg());
//                }
//                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlanbDetailVO detailVO = new PlanbDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String materialCode = datas.get(0);
//                    detailVO.setMaterialCode(materialCode);
//                    if(map.containsKey(materialCode)){
//                        MaterialVO materialVO =   map.get(materialCode);
//                        detailVO.setMaterialTypeId(materialVO.getCategoryId());
//                        detailVO.setMaterialTypeName(materialVO.getCategoryName());
//                        detailVO.setMaterialId(materialVO.getId());
//                        detailVO.setMaterialName(materialVO.getName());
//                        detailVO.setSpec(materialVO.getSpec());
//                        detailVO.setUnitId(materialVO.getUnitId());
//                        detailVO.setUnitName(materialVO.getUnitName());
//                    }else{
//                        detailVO.setErrorMsg("材料编码不匹配！");
//                        errorList.add(detailVO);
//                        continue;
//                    }
                    try {
                        // 这是获取 表格中的 金额数据
                        String detailMny = datas.get(1);
                        String MaxdetailMny = datas.get(4);
                        if (StringUtils.isNotBlank(detailMny) && StringUtils.isNotBlank(MaxdetailMny)) {
                            // 当 两个金额都不为空的时候
                            BigDecimal minMny = new BigDecimal(detailMny);
                            BigDecimal maxMny = new BigDecimal(detailMny);
                            int result1 = minMny.compareTo(maxMny);

                            if (result1 > 0) {
                               /*  detailVO.setErrorMsg("最低价格式错误！");
                                errorList.add(detailVO);
                                continue; */
                                throw new RuntimeException("excelImportMaterial 金额");
                            } else {
                                detailVO.setDetailPlanbMny(minMny);
                                detailVO.setDetailPlanbMaxMny(maxMny);
                            }
                        }
                    } catch (Exception e) {
                        detailVO.setErrorMsg("最低价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    String orgName = null;
                    try {
                        orgName = datas.get(3);
                        CommonResponse<OrgVO> byNameAndTenantId1 = iOrgApi.findByNameAndTenantId(orgName, 999999l);
                        if(ObjectUtils.isEmpty(byNameAndTenantId1)){
                            throw new RuntimeException("byNameAndTenantId1 组织是空");
                        }else{
                            detailVO.setOrgName(orgName);
                        }
                    } catch (Exception e) {
                        logger.error("e");
                    }


                    try {
                        String memo = datas.get(2);  // todo 下拉 ？？

                        CommonResponse<OrgVO> byNameAndTenantId = iOrgApi.findByNameAndTenantId(memo, 999999l);
                        System.out.println(byNameAndTenantId);

                       if(ObjectUtils.isEmpty(byNameAndTenantId)){
                           throw new RuntimeException("excelImportMaterial 金额");
                       }
                        detailVO.setOrgTest(memo);

                        if (memo.equals("集团")){
                            detailVO.setOrgType(1);
                        }else if (memo.equals("分公司")){
                            detailVO.setOrgType(2);
                        }else if (memo.equals("项目部")){
                            detailVO.setOrgType(3);
                        }else {
                            throw new Exception();
                        }

                    } catch (Exception e) {
                        detailVO.setErrorMsg("byNameAndTenantId");
                        logger.error("byNameAndTenantId",e);
                        errorList.add(detailVO);
                        continue;
                    }
                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}