/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.EmployeeBillEntity;
import com.ejianc.business.jltest.margin.bean.InspiritLossDetailEntity;
import com.ejianc.business.jltest.margin.bean.InspiritLossEntity;
import com.ejianc.business.jltest.margin.bean.MoneyRefundEntity;
import com.ejianc.business.jltest.margin.bean.RiskPayConfirmationEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeDetailService;
import com.ejianc.business.jltest.margin.service.IEmployeeBillService;
import com.ejianc.business.jltest.margin.service.IInspiritLossDetailService;
import com.ejianc.business.jltest.margin.service.IInspiritLossService;
import com.ejianc.business.jltest.margin.service.IMoneyRefundService;
import com.ejianc.business.jltest.margin.service.IRiskPayConfirmationService;
import com.ejianc.business.jltest.margin.vo.EmployeeBillVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"employeeBill"})
public class EmployeeBillController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDirectEmployeeDetailService directEmployeeDetailService;
    @Autowired
    private IRiskPayConfirmationService riskPayConfirmationService;
    @Autowired
    private IMoneyRefundService moneyRefundService;
    @Autowired
    private IInspiritLossDetailService inspiritLossDetailService;
    @Autowired
    private IInspiritLossService inspiritLossService;
    private static final String BILL_CODE = "EmployeeBill";
    @Autowired
    private IEmployeeBillService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EmployeeBillVO> saveOrUpdate(@RequestBody EmployeeBillVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        EmployeeBillEntity entity = (EmployeeBillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, EmployeeBillEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        EmployeeBillVO vo = (EmployeeBillVO)BeanMapper.map((Object)((Object)entity), EmployeeBillVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EmployeeBillVO> queryDetail(Long id) {
        ArrayList<InspiritLossEntity> inspiritLossList = new ArrayList();
        QueryWrapper inspiritLossEntityQueryWrapper = new QueryWrapper();
        inspiritLossEntityQueryWrapper.eq((Object)"employee_id", (Object)id);
        inspiritLossList = this.inspiritLossService.list((Wrapper)inspiritLossEntityQueryWrapper);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"employee_id", (Object)id);
        wrapper.select(new String[]{"distinct employee_name,phone"});
        DirectEmployeeDetailEntity directEmployeeDetailEntity = (DirectEmployeeDetailEntity)((Object)this.directEmployeeDetailService.getOne((Wrapper)wrapper));
        BigDecimal paidMny = BigDecimal.ZERO;
        BigDecimal refundMny = BigDecimal.ZERO;
        BigDecimal actualPaidMny = BigDecimal.ZERO;
        BigDecimal allotmentMny = BigDecimal.ZERO;
        EmployeeBillEntity employeeBillEntity = new EmployeeBillEntity();
        employeeBillEntity.setEmployeeName(directEmployeeDetailEntity.getEmployeeName());
        employeeBillEntity.setPhone(directEmployeeDetailEntity.getPhone());
        QueryWrapper rickPayConfirmationEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)rickPayConfirmationEntityQueryWrapper.select(new String[]{"sum(current_payment_amount) as current_payment_amount"}).eq((Object)"employee_id", (Object)id)).eq((Object)"isOk", (Object)1);
        RiskPayConfirmationEntity riskPayConfirmationResult = (RiskPayConfirmationEntity)((Object)this.riskPayConfirmationService.getOne((Wrapper)rickPayConfirmationEntityQueryWrapper));
        if (riskPayConfirmationResult != null) {
            paidMny = riskPayConfirmationResult.getCurrentPaymentAmount();
        }
        employeeBillEntity.setPaidMny(paidMny);
        QueryWrapper moneyRefundEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)moneyRefundEntityQueryWrapper.select(new String[]{"sum(current_period_actual_due) as current_period_actual_due"}).eq((Object)"employee_id", (Object)id)).eq((Object)"confirm_status", (Object)3);
        MoneyRefundEntity moneyRefundResult = (MoneyRefundEntity)((Object)this.moneyRefundService.getOne((Wrapper)moneyRefundEntityQueryWrapper));
        if (moneyRefundResult != null) {
            refundMny = moneyRefundResult.getCurrentPeriodActualDue();
        }
        employeeBillEntity.setRefundMny(refundMny);
        actualPaidMny = paidMny.subtract(refundMny);
        employeeBillEntity.setActualPaidMny(actualPaidMny);
        QueryWrapper inspiritLossQueryWrapper = new QueryWrapper();
        inspiritLossQueryWrapper.select(new String[]{"sum(detail_assessment) as detail_assessment"}).eq((Object)"detail_id", (Object)id);
        InspiritLossDetailEntity inspiritLossResult = (InspiritLossDetailEntity)((Object)this.inspiritLossDetailService.getOne((Wrapper)inspiritLossQueryWrapper));
        if (inspiritLossResult != null) {
            allotmentMny = inspiritLossResult.getDetailAssessment();
        }
        employeeBillEntity.setAllotmentMny(allotmentMny);
        employeeBillEntity.setInspiritLossList(inspiritLossList);
        EmployeeBillVO vo = (EmployeeBillVO)BeanMapper.map((Object)((Object)employeeBillEntity), EmployeeBillVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EmployeeBillVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EmployeeBillVO employeeBillVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EmployeeBillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (!CollectionUtils.isNotEmpty(commonOrgIds) && CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        ArrayList employeeBillList = new ArrayList();
        QueryWrapper wrapper = new QueryWrapper();
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        if (orgId != null) {
            wrapper.eq((Object)"org_id", ((Parameter)param.getParams().get("orgId")).getValue());
        }
        wrapper.select(new String[]{"distinct employee_id,employee_name"});
        List empList = this.directEmployeeDetailService.list((Wrapper)wrapper);
        IPage page = this.service.queryPage(param, false);
        for (DirectEmployeeDetailEntity emp : empList) {
            BigDecimal paidMny = BigDecimal.ZERO;
            BigDecimal refundMny = BigDecimal.ZERO;
            BigDecimal actualPaidMny = BigDecimal.ZERO;
            BigDecimal allotmentMny = BigDecimal.ZERO;
            EmployeeBillEntity employeeBillEntity = new EmployeeBillEntity();
            employeeBillEntity.setEmployeeName(emp.getEmployeeName());
            employeeBillEntity.setEmployeeId(emp.getEmployeeId());
            QueryWrapper rickPayConfirmationEntityQueryWrapper = new QueryWrapper();
            ((QueryWrapper)rickPayConfirmationEntityQueryWrapper.select(new String[]{"sum(current_payment_amount) as current_payment_amount"}).eq((Object)"employee_id", (Object)emp.getEmployeeId())).eq((Object)"isOk", (Object)1);
            RiskPayConfirmationEntity riskPayConfirmationResult = (RiskPayConfirmationEntity)((Object)this.riskPayConfirmationService.getOne((Wrapper)rickPayConfirmationEntityQueryWrapper));
            if (riskPayConfirmationResult != null) {
                paidMny = riskPayConfirmationResult.getCurrentPaymentAmount();
            }
            employeeBillEntity.setPaidMny(paidMny);
            QueryWrapper moneyRefundEntityQueryWrapper = new QueryWrapper();
            ((QueryWrapper)moneyRefundEntityQueryWrapper.select(new String[]{"sum(current_period_actual_due) as current_period_actual_due"}).eq((Object)"employee_id", (Object)emp.getEmployeeId())).eq((Object)"confirm_status", (Object)3);
            MoneyRefundEntity moneyRefundResult = (MoneyRefundEntity)((Object)this.moneyRefundService.getOne((Wrapper)moneyRefundEntityQueryWrapper));
            if (moneyRefundResult != null) {
                refundMny = moneyRefundResult.getCurrentPeriodActualDue();
            }
            employeeBillEntity.setRefundMny(refundMny);
            actualPaidMny = paidMny.subtract(refundMny);
            employeeBillEntity.setActualPaidMny(actualPaidMny);
            QueryWrapper inspiritLossQueryWrapper = new QueryWrapper();
            inspiritLossQueryWrapper.select(new String[]{"sum(detail_assessment) as detail_assessment"}).eq((Object)"detail_id", (Object)emp.getEmployeeId());
            InspiritLossDetailEntity inspiritLossResult = (InspiritLossDetailEntity)((Object)this.inspiritLossDetailService.getOne((Wrapper)inspiritLossQueryWrapper));
            if (inspiritLossResult != null) {
                allotmentMny = inspiritLossResult.getDetailAssessment();
            }
            employeeBillEntity.setAllotmentMny(allotmentMny);
            System.out.println(employeeBillEntity.toString());
            page.getRecords().add(employeeBillEntity);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EmployeeBillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        ArrayList<EmployeeBillEntity> list = new ArrayList<EmployeeBillEntity>();
        QueryWrapper wrapper = new QueryWrapper();
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        if (orgId != null) {
            wrapper.eq((Object)"org_id", ((Parameter)param.getParams().get("orgId")).getValue());
        }
        wrapper.select(new String[]{"distinct employee_id,employee_name"});
        List empList = this.directEmployeeDetailService.list((Wrapper)wrapper);
        IPage page = this.service.queryPage(param, false);
        for (DirectEmployeeDetailEntity emp : empList) {
            BigDecimal paidMny = BigDecimal.ZERO;
            BigDecimal refundMny = BigDecimal.ZERO;
            BigDecimal actualPaidMny = BigDecimal.ZERO;
            BigDecimal allotmentMny = BigDecimal.ZERO;
            EmployeeBillEntity employeeBillEntity = new EmployeeBillEntity();
            employeeBillEntity.setEmployeeName(emp.getEmployeeName());
            employeeBillEntity.setEmployeeId(emp.getEmployeeId());
            QueryWrapper rickPayConfirmationEntityQueryWrapper = new QueryWrapper();
            ((QueryWrapper)rickPayConfirmationEntityQueryWrapper.select(new String[]{"sum(current_payment_amount) as current_payment_amount"}).eq((Object)"employee_id", (Object)emp.getEmployeeId())).eq((Object)"isOk", (Object)1);
            RiskPayConfirmationEntity riskPayConfirmationResult = (RiskPayConfirmationEntity)((Object)this.riskPayConfirmationService.getOne((Wrapper)rickPayConfirmationEntityQueryWrapper));
            if (riskPayConfirmationResult != null) {
                paidMny = riskPayConfirmationResult.getCurrentPaymentAmount();
            }
            employeeBillEntity.setPaidMny(paidMny);
            QueryWrapper moneyRefundEntityQueryWrapper = new QueryWrapper();
            ((QueryWrapper)moneyRefundEntityQueryWrapper.select(new String[]{"sum(current_period_actual_due) as current_period_actual_due"}).eq((Object)"employee_id", (Object)emp.getEmployeeId())).eq((Object)"confirm_status", (Object)3);
            MoneyRefundEntity moneyRefundResult = (MoneyRefundEntity)((Object)this.moneyRefundService.getOne((Wrapper)moneyRefundEntityQueryWrapper));
            if (moneyRefundResult != null) {
                refundMny = moneyRefundResult.getCurrentPeriodActualDue();
            }
            employeeBillEntity.setRefundMny(refundMny);
            actualPaidMny = paidMny.subtract(refundMny);
            employeeBillEntity.setActualPaidMny(actualPaidMny);
            QueryWrapper inspiritLossQueryWrapper = new QueryWrapper();
            inspiritLossQueryWrapper.select(new String[]{"sum(detail_assessment) as detail_assessment"}).eq((Object)"detail_id", (Object)emp.getEmployeeId());
            InspiritLossDetailEntity inspiritLossResult = (InspiritLossDetailEntity)((Object)this.inspiritLossDetailService.getOne((Wrapper)inspiritLossQueryWrapper));
            if (inspiritLossResult != null) {
                allotmentMny = inspiritLossResult.getDetailAssessment();
            }
            employeeBillEntity.setAllotmentMny(allotmentMny);
            System.out.println(employeeBillEntity.toString());
            list.add(employeeBillEntity);
        }
        HashMap<String, ArrayList<EmployeeBillEntity>> beans = new HashMap<String, ArrayList<EmployeeBillEntity>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EmployeeBill-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEmployeeBillData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EmployeeBillVO>> refEmployeeBillData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EmployeeBillVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

