/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.MoneyRefundEntity;
import com.ejianc.business.jltest.margin.bean.PaymentDetailsEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeDetailService;
import com.ejianc.business.jltest.margin.service.IMoneyRefundService;
import com.ejianc.business.jltest.margin.service.IPaymentDetailsService;
import com.ejianc.business.jltest.margin.vo.MoneyRefundVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"moneyRefund"})
public class MoneyRefundController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "REFUND_CODE";
    @Autowired
    private IMoneyRefundService service;
    @Autowired
    private IDirectEmployeeDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPaymentDetailsService paymentDetailsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MoneyRefundVO> saveOrUpdate(@RequestBody MoneyRefundVO saveOrUpdateVO) {
        MoneyRefundEntity entity = (MoneyRefundEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MoneyRefundEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        DirectEmployeeDetailEntity employeeDetailEntity = (DirectEmployeeDetailEntity)((Object)this.detailService.getById(saveOrUpdateVO.getEmployeeSchedulesId()));
        employeeDetailEntity.setHasRecord(2);
        this.detailService.updateById((Object)employeeDetailEntity);
        entity.setConfirmStatus(1);
        this.service.saveOrUpdate((Object)entity, false);
        MoneyRefundVO vo = (MoneyRefundVO)BeanMapper.map((Object)((Object)entity), MoneyRefundVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MoneyRefundVO> queryDetail(Long id) {
        MoneyRefundEntity entity = (MoneyRefundEntity)((Object)this.service.selectById(id));
        if (entity != null) {
            MoneyRefundVO vo = (MoneyRefundVO)BeanMapper.map((Object)((Object)entity), MoneyRefundVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        if (entity == null) {
            MoneyRefundVO moneyRefundVO = new MoneyRefundVO();
            PaymentDetailsEntity paymentDetailsEntity = (PaymentDetailsEntity)((Object)this.paymentDetailsService.selectById(id));
            BeanUtils.copyProperties((Object)((Object)paymentDetailsEntity), (Object)moneyRefundVO);
            Long transferId = paymentDetailsEntity.getTransferId();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BaseEntity::getId, (Object)transferId);
            MoneyRefundEntity one = (MoneyRefundEntity)((Object)this.service.getOne((Wrapper)wrapper));
            moneyRefundVO.setApprovedOutputValue(one.getApprovedOutputValue());
            moneyRefundVO.setIncludeCurrentPeriodActualActualDue(one.getIncludeCurrentPeriodActualActualDue());
            moneyRefundVO.setDue(one.getDue());
            moneyRefundVO.setRefundDate(one.getRefundDate());
            moneyRefundVO.setMobilizeOrgId(one.getMobilizeOrgId());
            moneyRefundVO.setCurrentPeriodActualDue(one.getCurrentPeriodActualDue());
            moneyRefundVO.setIncludeCurrentPeriodActualActualPercentage(one.getIncludeCurrentPeriodActualActualPercentage());
            moneyRefundVO.setMemo(one.getMemo());
            moneyRefundVO.setEmployeeSchedulesId(one.getEmployeeSchedulesId());
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)moneyRefundVO);
        }
        return CommonResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MoneyRefundVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MoneyRefundVO moneyRefundVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MoneyRefundVO>> queryList(@RequestBody QueryParam param) {
        String searchText = param.getSearchText();
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        if (searchText != null) {
            map.put("billCode", new Parameter("like", (Object)searchText));
            param.setParams(map);
            IPage page = this.service.queryPage(param, false);
            if (page.getTotal() == 0L) {
                map.clear();
                map.put("employeeName", new Parameter("like", (Object)searchText));
                param.setParams(map);
                page = this.service.queryPage(param, false);
                if (page.getTotal() == 0L) {
                    map.clear();
                    map.put("orgName", new Parameter("like", (Object)searchText));
                    param.setParams(map);
                    page = this.service.queryPage(param, false);
                }
            }
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = new ArrayList();
        resDatas = BeanMapper.mapList((Iterable)list, MoneyRefundVO.class);
        for (MoneyRefundVO entity : resDatas) {
            switch (entity.getType()) {
                case 1: {
                    entity.setTypeName("\u9000\u8fd8");
                    break;
                }
                case 2: {
                    entity.setTypeName("\u8c03\u52a8");
                }
            }
            switch (entity.getConfirmStatus()) {
                case 1: {
                    entity.setConfirmStatusName("\u5f85\u786e\u8ba4");
                    break;
                }
                case 2: {
                    entity.setConfirmStatusName("\u786e\u8ba4\u4e2d");
                    break;
                }
                case 3: {
                    entity.setConfirmStatusName("\u5df2\u786e\u8ba4");
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("MoneyRefund-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMoneyRefundData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MoneyRefundVO>> refMoneyRefundData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MoneyRefundVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

