/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jltest.margin.bean.AssessCashDetailEntity;
import com.ejianc.business.jltest.margin.bean.AssessCashDetailSumEntity;
import com.ejianc.business.jltest.margin.bean.AssessCashEntity;
import com.ejianc.business.jltest.margin.bean.CashAmountEntity;
import com.ejianc.business.jltest.margin.bean.CashEntity;
import com.ejianc.business.jltest.margin.service.IAssessCashService;
import com.ejianc.business.jltest.margin.service.ICashAmountService;
import com.ejianc.business.jltest.margin.service.ICashService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assessCash")
public class AssessCashBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssessCashService assessCashService;
    @Autowired
    private ICashService cashService;
    @Autowired
    private ICashAmountService cashAmountService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u66f4\u6539\u4e0a\u6e38\u6570\u636e\u4fe1\u606f");
        QueryWrapper queryWrapper = new QueryWrapper();
        AssessCashEntity assessCash = (AssessCashEntity)((Object)this.assessCashService.getById(billId));
        List<AssessCashDetailEntity> assessCashDetailList = assessCash.getAssessCashDetailList();
        this.logger.info("\u64a4\u56de--\u4e0a\u6e38\u6570\u636e\u6570\u91cf" + assessCashDetailList.size());
        for (AssessCashDetailEntity cashDetail : assessCashDetailList) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)cashDetail.getCashId());
            updateWrapper.set(CashEntity::getFlag, (Object)1);
            this.cashService.update((Wrapper)updateWrapper);
        }
        List<AssessCashDetailSumEntity> assessCashDetailSumList = assessCash.getAssessCashDetailSumList();
        this.logger.info("\u64a4\u56de--\u4e0a\u6e38\u6570\u636e\u6570\u91cf\u6c47\u603b" + assessCashDetailSumList.size());
        for (AssessCashDetailSumEntity cashsumDetail : assessCashDetailSumList) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)cashsumDetail.getCashSumId());
            updateWrapper.set(CashAmountEntity::getFlag, (Object)1);
            this.cashAmountService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u66f4\u6539\u4e0a\u6e38\u6570\u636e\u4fe1\u606f");
        AssessCashEntity assessCash = (AssessCashEntity)((Object)this.assessCashService.selectById(billId));
        List<AssessCashDetailEntity> assessCashDetailList = assessCash.getAssessCashDetailList();
        this.logger.info("\u63d0\u4ea4--\u4e0a\u6e38\u6570\u636e\u6570\u91cf" + assessCashDetailList.size());
        for (AssessCashDetailEntity cashDetail : assessCashDetailList) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)cashDetail.getCashId());
            updateWrapper.set(CashEntity::getFlag, (Object)0);
            this.cashService.update((Wrapper)updateWrapper);
        }
        List<AssessCashDetailSumEntity> cashDetailSumEntityList = assessCash.getAssessCashDetailSumList();
        this.logger.info("\u63d0\u4ea4--\u4e0a\u6e38\u6570\u636e\u6570\u91cf\u6c47\u603b" + cashDetailSumEntityList.size());
        for (AssessCashDetailSumEntity cashDetail : cashDetailSumEntityList) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)cashDetail.getCashSumId());
            updateWrapper.set(CashAmountEntity::getFlag, (Object)0);
            this.cashAmountService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

