/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.orgtest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlanbDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanbEntity;
import com.ejianc.business.jltest.orgtest.service.IPlanbService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.service.impl.PlanbDetailServiceImpl;
import com.ejianc.business.jltest.orgtest.vo.PlanbDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlanbVO;
import com.ejianc.business.jltest.orgtest.vo.PlanbVO1;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"planb"})
public class PlanbController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PLAN-B";
    @Autowired
    private IPlanbService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISafeteambService safeteambService;
    @Autowired
    private PlanbDetailServiceImpl planbDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanbVO> saveOrUpdate(@RequestBody PlanbVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanbVO> queryDetail(Long id) {
        PlanbEntity entity = (PlanbEntity)((Object)this.service.selectById(id));
        PlanbVO vo = (PlanbVO)BeanMapper.map((Object)((Object)entity), PlanbVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanbVO> vos) {
        this.service.removeByIdsRewrite(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanbVO1>> queryList(@RequestBody QueryParam param) {
        String employeeName = this.sessionManager.getUserContext().getEmployeeName();
        Map params = param.getParams();
        for (Map.Entry stringParameterEntry : params.entrySet()) {
            String key = (String)stringParameterEntry.getKey();
            Parameter value = (Parameter)stringParameterEntry.getValue();
            Object value1 = value.getValue();
            if (key.equals("employeeName") && value1.equals("yes")) {
                param.getParams().put("employeeName", new Parameter("eq", (Object)employeeName));
            }
            if (!key.equals("employeeName") || !value1.equals("no")) continue;
            param.getParams().put("employeeName", new Parameter("ne", (Object)employeeName));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("safeteambId");
        fuzzyFields.add("planbName");
        fuzzyFields.add("planbMny");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resDatas = new ArrayList();
        ArrayList objects = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), PlanbVO1.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(PlanbDetailEntity::getPlanbId, ids);
            List resList = this.planbDetailService.list((Wrapper)lambda);
            List unsettleListVOList = BeanMapper.mapList((Iterable)resList, PlanbVO1.class);
            if (CollectionUtils.isNotEmpty((Collection)unsettleListVOList)) {
                unsettleListVOList.forEach(e -> {
                    e.setBillState((Integer)map.get(e.getPlanbId()));
                    e.setCreateTime(e.getCreateTime());
                    e.setPlanbMny(e.getDetailPlanbMny());
                    e.setPlanbName(e.getDetailPlanbName());
                });
                resDatas.addAll(unsettleListVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanbVO1.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        String employeeName = this.sessionManager.getUserContext().getEmployeeName();
        Map params = param.getParams();
        for (Map.Entry stringParameterEntry : params.entrySet()) {
            String key = (String)stringParameterEntry.getKey();
            Parameter value = (Parameter)stringParameterEntry.getValue();
            Object value1 = value.getValue();
            if (key.equals("employeeName") && value1.equals("yes")) {
                param.getParams().put("employeeName", new Parameter("eq", (Object)employeeName));
            }
            if (!key.equals("employeeName") || !value1.equals("no")) continue;
            param.getParams().put("employeeName", new Parameter("ne", (Object)employeeName));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("safeteambId");
        fuzzyFields.add("planbName");
        fuzzyFields.add("planbMny");
        fuzzyFields.add("employeeName");
        Map params1 = param.getParams();
        Parameter parameter = new Parameter("eq", (Object)InvocationInfoProxy.getTenantid());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PlanbDetailEntity::getPlanbId, collect);
        List deatilList = this.planbDetailService.list((Wrapper)wrapper);
        PlanbEntity planbEntity = new PlanbEntity();
        for (PlanbDetailEntity planbDetailEntity : deatilList) {
            planbEntity.setOrgName(planbDetailEntity.getOrgName());
            planbEntity.setPlanbName(planbDetailEntity.getDetailPlanbName());
            planbEntity.setCreateTime(planbDetailEntity.getCreateTime());
            planbEntity.setPlanbMny(planbDetailEntity.getDetailPlanbMny());
            list.add(planbEntity);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Planb-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanbData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanbVO>> refPlanbData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanbVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadInfo"})
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Planb-Detail-import.xlsx", (String)"\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PlanbDetailVO> successList = new ArrayList<PlanbDetailVO>();
        ArrayList<PlanbDetailVO> errorList = new ArrayList<PlanbDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                PlanbDetailVO detailVO;
                block17: {
                    List datas;
                    block16: {
                        datas = (List)result.get(i);
                        detailVO = new PlanbDetailVO();
                        detailVO.setId(Long.valueOf(IdWorker.getId()));
                        String materialCode = (String)datas.get(0);
                        try {
                            String detailMny = (String)datas.get(1);
                            String MaxdetailMny = (String)datas.get(4);
                            if (!StringUtils.isNotBlank((CharSequence)detailMny) || !StringUtils.isNotBlank((CharSequence)MaxdetailMny)) break block16;
                            BigDecimal minMny = new BigDecimal(detailMny);
                            BigDecimal maxMny = new BigDecimal(detailMny);
                            int result1 = minMny.compareTo(maxMny);
                            if (result1 > 0) {
                                throw new RuntimeException("excelImportMaterial \u91d1\u989d");
                            }
                            detailVO.setDetailPlanbMny(minMny);
                            detailVO.setDetailPlanbMaxMny(maxMny);
                        }
                        catch (Exception e) {
                            detailVO.setErrorMsg("\u6700\u4f4e\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                            errorList.add(detailVO);
                            continue;
                        }
                    }
                    String orgName = null;
                    try {
                        orgName = (String)datas.get(3);
                        CommonResponse byNameAndTenantId1 = this.iOrgApi.findByNameAndTenantId(orgName, Long.valueOf(999999L));
                        if (ObjectUtils.isEmpty((Object)byNameAndTenantId1)) {
                            throw new RuntimeException("byNameAndTenantId1 \u7ec4\u7ec7\u662f\u7a7a");
                        }
                        detailVO.setOrgName(orgName);
                    }
                    catch (Exception e) {
                        this.logger.error("e");
                    }
                    try {
                        String memo = (String)datas.get(2);
                        CommonResponse byNameAndTenantId = this.iOrgApi.findByNameAndTenantId(memo, Long.valueOf(999999L));
                        System.out.println(byNameAndTenantId);
                        if (ObjectUtils.isEmpty((Object)byNameAndTenantId)) {
                            throw new RuntimeException("excelImportMaterial \u91d1\u989d");
                        }
                        detailVO.setOrgTest(memo);
                        if (memo.equals("\u96c6\u56e2")) {
                            detailVO.setOrgType(Integer.valueOf(1));
                            break block17;
                        }
                        if (memo.equals("\u5206\u516c\u53f8")) {
                            detailVO.setOrgType(Integer.valueOf(2));
                            break block17;
                        }
                        if (memo.equals("\u9879\u76ee\u90e8")) {
                            detailVO.setOrgType(Integer.valueOf(3));
                            break block17;
                        }
                        throw new Exception();
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("byNameAndTenantId");
                        this.logger.error("byNameAndTenantId", (Throwable)e);
                        errorList.add(detailVO);
                        continue;
                    }
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

