package com.ejianc.business.jltest.margin.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.DirectPaidEmployeeEntity;
import com.ejianc.business.jltest.margin.bean.RiskPayConfirmationEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeDetailService;
import com.ejianc.business.jltest.margin.service.IDirectPaidEmployeeService;
import com.ejianc.business.jltest.margin.service.IRiskPayConfirmationService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.util.concurrent.AtomicDouble;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.margin.bean.PaymentDetailsEntity;
import com.ejianc.business.jltest.margin.service.IPaymentDetailsService;
import com.ejianc.business.jltest.margin.vo.PaymentDetailsVO;

/**
 * 缴纳详情表 b
 *
 * @author generator
 */
@Controller
@RequestMapping("paymentDetails")
public class PaymentDetailsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RiskFund";//此处需要根据实际修改

    @Autowired
    private IPaymentDetailsService service;

    @Autowired
    private IRiskPayConfirmationService riskPayservice;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDirectEmployeeDetailService iDirectEmployeeDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PaymentDetailsVO> saveOrUpdate(@RequestBody PaymentDetailsVO saveOrUpdateVO) {
        PaymentDetailsEntity entity = BeanMapper.map(saveOrUpdateVO, PaymentDetailsEntity.class);
        //设置默认值。-1 确认中。后续有问题 记得来改
        entity.setConfirmationState(-1);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行

                Long employeeDetailId = saveOrUpdateVO.getEmployeeDetailId();
                //构建查询条件
                LambdaQueryWrapper<DirectEmployeeDetailEntity> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(DirectEmployeeDetailEntity::getId, employeeDetailId);
                //设置值
                DirectEmployeeDetailEntity detail = iDirectEmployeeDetailService.getOne(wrapper);
                detail.setHasRecord(2); //设置成2 当当前单据存在 未确认的单据的时候，不允许再新增

                iDirectEmployeeDetailService.updateById(detail);
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PaymentDetailsVO vo = BeanMapper.map(entity, PaymentDetailsVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentDetailsVO> queryDetail(Long id) {
        PaymentDetailsEntity entity = service.selectById(id);
        PaymentDetailsVO vo = BeanMapper.map(entity, PaymentDetailsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentDetailsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PaymentDetailsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(PaymentDetailsVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            //根据先查 缴纳相详情
            LambdaQueryWrapper<PaymentDetailsEntity> wrapper1 = new LambdaQueryWrapper<>();
            wrapper1.eq(PaymentDetailsEntity::getId, id);

            //构建查询条件 查询员工明细表
            PaymentDetailsEntity one = service.getOne(wrapper1);
            LambdaQueryWrapper<DirectEmployeeDetailEntity> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(DirectEmployeeDetailEntity::getId, one.getEmployeeDetailId());
            DirectEmployeeDetailEntity one1 = iDirectEmployeeDetailService.getOne(wrapper2);
            one1.setHasRecord(1);
            iDirectEmployeeDetailService.updateById(one1);
        }


            service.removeByIds(vos.stream().map(PaymentDetailsVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PaymentDetailsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //登陆人本人的缴纳信息
        String name = sessionManager.getUserContext().getEmployeeName();
        param.getParams().put("employeeName", new Parameter(QueryParam.EQ, name));

        IPage<PaymentDetailsEntity> page = service.queryPage(param, false);
        IPage<PaymentDetailsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentDetailsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PaymentDetailsEntity> list = service.queryList(param);

        List<PaymentDetailsVO> listVo = BeanMapper.mapList(list, PaymentDetailsVO.class);

        for (PaymentDetailsVO paymentDetailsVO : listVo) {
            Integer type = paymentDetailsVO.getType();
            if (type == 0) {
                paymentDetailsVO.setTypeVo("新增");
            }
            if (type == 1) {
                paymentDetailsVO.setTypeVo("退还");
            }
            if (type == 2) {
                paymentDetailsVO.setTypeVo("转让");
            }


        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("Risk_fund-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPaymentDetailsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PaymentDetailsVO>> refPaymentDetailsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PaymentDetailsEntity> page = service.queryPage(param, false);
        IPage<PaymentDetailsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PaymentDetailsVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


/*    @GetMapping("/selectByid")
    @ResponseBody
    public CommonResponse selectByid(String id) {
        LambdaQueryWrapper<RiskPayConfirmationEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RiskPayConfirmationEntity::getEmployeeDetailId, id)
                .eq(RiskPayConfirmationEntity::getIsok, 1)
                .eq(RiskPayConfirmationEntity::getDr, 0);
        RiskPayConfirmationEntity entity = riskPayservice.selectAcount(wrapper);
        System.out.println(id);
        return CommonResponse.success("数据更新成功");
    }*/
}
