package com.ejianc.business.jltest.margin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jltest.margin.bean.*;
import com.ejianc.business.jltest.margin.service.IAssessCashService;
import com.ejianc.business.jltest.margin.service.ICashAmountService;
import com.ejianc.business.jltest.margin.service.ICashService;
import com.ejianc.business.jltest.orgtest.bean.DangeraEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.vo.DangeraVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("assessCash")
public class AssessCashBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAssessCashService assessCashService;
	@Autowired
	private ICashService cashService;
	@Autowired
	private ICashAmountService cashAmountService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		//撤回将上游数据状态改为1
		logger.info("更改上游数据信息");
		//更改上游数据信息
		QueryWrapper<AssessCashEntity> queryWrapper = new QueryWrapper<>();
		AssessCashEntity assessCash = assessCashService.getById(billId);
		//获取上游数据
		List<AssessCashDetailEntity> assessCashDetailList = assessCash.getAssessCashDetailList();
		logger.info("撤回--上游数据数量"+assessCashDetailList.size());
		for (AssessCashDetailEntity cashDetail:assessCashDetailList) {
			LambdaUpdateWrapper<CashEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(CashEntity::getId,cashDetail.getCashId());
			updateWrapper.set(CashEntity::getFlag,1);
			cashService.update(updateWrapper);
		}
		List<AssessCashDetailSumEntity> assessCashDetailSumList = assessCash.getAssessCashDetailSumList();
		logger.info("撤回--上游数据数量汇总"+assessCashDetailSumList.size());
		for (AssessCashDetailSumEntity cashsumDetail:assessCashDetailSumList) {
			LambdaUpdateWrapper<CashAmountEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(CashAmountEntity::getId,cashsumDetail.getCashSumId());
			updateWrapper.set(CashAmountEntity::getFlag,1);
			cashAmountService.update(updateWrapper);
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//提交后上游数据的状态改为0
		logger.info("更改上游数据信息");
		//更改上游数据信息
		AssessCashEntity assessCash = assessCashService.selectById(billId);
		//获取上游数据
		List<AssessCashDetailEntity> assessCashDetailList = assessCash.getAssessCashDetailList();
		logger.info("提交--上游数据数量"+assessCashDetailList.size());
		for (AssessCashDetailEntity cashDetail:assessCashDetailList) {
			LambdaUpdateWrapper<CashEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(CashEntity::getId,cashDetail.getCashId());
			updateWrapper.set(CashEntity::getFlag,0);
			cashService.update(updateWrapper);
		}
		List<AssessCashDetailSumEntity> cashDetailSumEntityList = assessCash.getAssessCashDetailSumList();
		logger.info("提交--上游数据数量汇总"+cashDetailSumEntityList.size());
		for (AssessCashDetailSumEntity cashDetail:cashDetailSumEntityList) {
			LambdaUpdateWrapper<CashAmountEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(CashAmountEntity::getId,cashDetail.getCashSumId());
			updateWrapper.set(CashAmountEntity::getFlag,0);
			cashAmountService.update(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//做检验 检验当前单据是否被下游引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
