package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jltest.orgtest.bean.DangeraEntity;
import com.ejianc.business.jltest.orgtest.bean.DangercEntity;
import com.ejianc.business.jltest.orgtest.bean.PlancEntity;
import com.ejianc.business.jltest.orgtest.mapper.PlancMapper;
import com.ejianc.business.jltest.orgtest.service.IDangercService;
import com.ejianc.business.jltest.orgtest.vo.DangercVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.mysql.fabric.xmlrpc.base.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("planc")
public class PlancBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private PlancServiceImpl plancService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDangercService dangercService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "DANGERC_CODE";//此处需要根据实际修改
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        PlancEntity plancEntity = plancService.selectById(billId);
        if (1 == state) {
            logger.info("planc无审批流直审开始执行");
            plancEntity.setSubmitEmployeeId(sessionManager.getUserContext().getEmployeeId());
            plancEntity.setSubmitEmployeeName(sessionManager.getUserContext().getEmployeeName());
            plancEntity.setSubmitDate(new Date());
            plancService.updateById(plancEntity);
            logger.info("planc无审批流直审执行完毕");
        }

        DangercVO entityVO = new DangercVO();
        entityVO.setDangerName(plancEntity.getPlanName() + "会议隐患");
        entityVO.setSafeteamcDate(plancEntity.getPlanDate());
        entityVO.setIsGen(1);
        entityVO.setPlancId(plancEntity.getId());

        // org参照迁移
        entityVO.setOrgId(plancEntity.getOrgId());
        entityVO.setOrgName(plancEntity.getOrgName());
        entityVO.setOrgCode(plancEntity.getOrgCode());
        //经办人参照迁移
        entityVO.setEmployeeId(plancEntity.getEmployeeId());
        entityVO.setEmployeeName(plancEntity.getEmployeeName());
        //经办部门参照迁移
        entityVO.setDepartmentId(plancEntity.getDepartmentId());
        entityVO.setDepartmentName(plancEntity.getDepartmentName());

        DangercEntity entity = BeanMapper.map(entityVO, DangercEntity.class);

        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), entityVO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        } else {
            logger.info("billCode生成异常，计划C审批生成隐患判定C失败");
        }
        attachmentApi.copyFilesFromSourceBillToTargetBill(plancEntity.getId().toString(),"EJCBT202403000022","planc1",entity.getId().toString(),"EJCBT202403000030","dangerc1");

        dangercService.saveOrUpdate(entity, false);

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("弃审后事件回调执行开始");
        LambdaQueryWrapper<DangercEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DangercEntity::getPlancId, billId);
        List<DangercEntity> dangercs = dangercService.list(queryWrapper);
        List<Long> ids = new ArrayList<Long>();
        for (DangercEntity dangerc : dangercs) {
            if (dangerc.getBillState() == 1 || dangerc.getBillState() == 3) {
                return CommonResponse.error("下游存在引用数据已提交，无法删除");
            } else {
                dangerc.setDr(1);
            }
        }
        dangercService.removeByIds(ids, true);
        logger.info("弃审后事件回调执行结束");
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
