package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jltest.orgtest.bean.*;
import com.ejianc.business.jltest.orgtest.mapper.PlandMapper;
import com.ejianc.business.jltest.orgtest.service.IDangerdService;
import com.ejianc.business.jltest.orgtest.service.IPlandService;
import com.ejianc.business.jltest.orgtest.service.ISafeteambService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamdService;
import com.ejianc.business.jltest.orgtest.vo.DangerdVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


@Service("pland") 
public class PlandBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private IBillCodeApi billCodeApi;

	@Autowired
	private IAttachmentApi attachmentApi;
	private static final String BILL_CODE = "DANGERD_CODE";
	@Autowired
	private IPlandService plandService;
	@Autowired
	private IDangerdService dangerdService;
	@Autowired
	private ISafeteamdService safeteamdService;
	@Autowired
	private SessionManager sessionManager;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//提交时填充提交人和提交时间
		PlandEntity plandEntity = plandService.selectById(billId);
		plandEntity.setSubmitName(sessionManager.getUserContext().getEmployeeName());
		plandEntity.setSubmitTime(new Date());
		plandService.updateById(plandEntity);

		SafeteamdEntity safeteamd = safeteamdService.selectById(plandEntity.getSafeteamdId());
		safeteamd.setPlanFlag(2);
		safeteamdService.updateById(safeteamd);

		//生成重大事故隐患判断单据
		DangerdVO dangerdVO = new DangerdVO();
		dangerdVO.setOrgId(plandEntity.getOrgId());
		dangerdVO.setOrgName(plandEntity.getOrgName());
		dangerdVO.setOrgCode(plandEntity.getOrgCode());
		dangerdVO.setDangerName(plandEntity.getPlanName());
		dangerdVO.setSelfCheckDate(plandEntity.getPlanDate());
		dangerdVO.setEmployeeId(plandEntity.getEmployeeId());
		dangerdVO.setEmployeeName(plandEntity.getEmployeeName());
		dangerdVO.setDepartmentId(plandEntity.getDepartmentId());
		dangerdVO.setDepartmentName(plandEntity.getDepartmentName());
		dangerdVO.setGenType(1);
		dangerdVO.setBillState(1);

		//生成billCode
		DangerdEntity dangerd = BeanMapper.map(dangerdVO, DangerdEntity.class);
		BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), dangerdVO);
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);

		dangerd.setBillCode(billCode.getData());

		dangerdService.saveOrUpdate(dangerd,false);

		attachmentApi.copyFilesFromSourceBillToTargetBill(plandEntity.getId().toString(),"EJCBT202403000025","pland1",dangerd.getId().toString(),"EJCBT202403000026","dangerd1");

		return CommonResponse.success();

	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//弃审校验
		LambdaQueryWrapper<DangerdEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(DangerdEntity::getPlandId, billId);
		List<DangerdEntity> dangerds = dangerdService.list(queryWrapper);
		List<Long> ids = new ArrayList<Long>();
		for (DangerdEntity dangerd : dangerds) {
			if (dangerd.getBillState() == 1 || dangerd.getBillState() == 3) {
				return CommonResponse.error("该单据的下游单据已提交，无法删除被引用的单据");
			} else {
				dangerd.setDr(1);
			}
		}
		dangerdService.removeByIds(ids, true);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
