package com.ejianc.business.jltest.margin.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
 * 考核兑现审批表
 *
 * @author generator
 *
 */
 @TableName("ejc_jltest_assess_cash")
public class AssessCashEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 项目责任书编号
    @TableField(value="assess_name")
    private String assessName; // 节点阶段
    @TableField(value="assess_manger")
    private String assessManger; // 项目经理
    @TableField(value="assess_inspection")
    private String assessInspection; // 工程检验情况
    @TableField(value="assess_pigeonhole")
    private String assessPigeonhole; // 竣工资料归档情况
    @TableField(value="assess_payment")
    private String assessPayment; // 分包工程付款情况
    @TableField(value="assess_verification")
    private String assessVerification; // 甲供材料核销情况
    @TableField(value="assess_warranty")
    private String assessWarranty; // 质保金及期限
    @TableField(value="validated_mny")
    private BigDecimal validatedMny; // 审定造价
    @TableField(value="liability_mny")
    private BigDecimal liabilityMny; // 项目责任成本
    @TableField(value="payable_mny")
    private BigDecimal payableMny; // 应交公司管理费
    @TableField(value="delivered_mny")
    private BigDecimal deliveredMny; // 已交公司管理费
    @TableField(value="profit_mny")
    private BigDecimal profitMny; // 项目盈利或亏损金额
    @TableField(value="loan_mny")
    private BigDecimal loanMny; // 项目借款
    @TableField(value="due_risk_mny")
    private BigDecimal dueRiskMny; // 应缴风险抵押金
    @TableField(value="pay_risk_mny")
    private BigDecimal payRiskMny; // 已交风险抵押金
    @TableField(value="quality_accident_mny")
    private BigDecimal qualityAccidentMny; // 质量事故损失金额
    @TableField(value="subcontract_mny")
    private BigDecimal subcontractMny; // 分包工程造价
    @TableField(value="safe_accident_mny")
    private BigDecimal safeAccidentMny; // 安全事故损失金额
    @TableField(value="received_mny")
    private BigDecimal receivedMny; // 已收工程款
    @TableField(value="cash_mny")
    private BigDecimal cashMny; // 亏损及罚款扣兑现奖
    @TableField(value="other_cash_mny")
    private BigDecimal otherCashMny; // 其他扣兑现奖款项
    @TableField(value="assess_mny")
    private BigDecimal assessMny; // 考核兑现金额
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="parent_org_name")
    private String parentOrgName; //
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist=false)
    @SubEntity(serviceName="assessCashDetailService",pidName = "assessId")
    private List<AssessCashDetailEntity> assessCashDetailList = new ArrayList<>(); // 考核兑现明细表
    @TableField(exist=false)
    @SubEntity(serviceName="assessCashDetailSumService",pidName = "assessId")
    private List<AssessCashDetailSumEntity> assessCashDetailSumList = new ArrayList<>(); // 考核兑现汇总明细表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getAssessName() {
        return assessName;
    }

    public void setAssessName(String assessName) {
        this.assessName = assessName;
    }
    public String getAssessManger() {
        return assessManger;
    }

    public void setAssessManger(String assessManger) {
        this.assessManger = assessManger;
    }
    public String getAssessInspection() {
        return assessInspection;
    }

    public void setAssessInspection(String assessInspection) {
        this.assessInspection = assessInspection;
    }
    public String getAssessPigeonhole() {
        return assessPigeonhole;
    }

    public void setAssessPigeonhole(String assessPigeonhole) {
        this.assessPigeonhole = assessPigeonhole;
    }
    public String getAssessPayment() {
        return assessPayment;
    }

    public void setAssessPayment(String assessPayment) {
        this.assessPayment = assessPayment;
    }
    public String getAssessVerification() {
        return assessVerification;
    }

    public void setAssessVerification(String assessVerification) {
        this.assessVerification = assessVerification;
    }
    public String getAssessWarranty() {
        return assessWarranty;
    }

    public void setAssessWarranty(String assessWarranty) {
        this.assessWarranty = assessWarranty;
    }
    public BigDecimal getValidatedMny() {
        return validatedMny;
    }

    public void setValidatedMny(BigDecimal validatedMny) {
        this.validatedMny = validatedMny;
    }
    public BigDecimal getLiabilityMny() {
        return liabilityMny;
    }

    public void setLiabilityMny(BigDecimal liabilityMny) {
        this.liabilityMny = liabilityMny;
    }
    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }
    public BigDecimal getDeliveredMny() {
        return deliveredMny;
    }

    public void setDeliveredMny(BigDecimal deliveredMny) {
        this.deliveredMny = deliveredMny;
    }
    public BigDecimal getProfitMny() {
        return profitMny;
    }

    public void setProfitMny(BigDecimal profitMny) {
        this.profitMny = profitMny;
    }
    public BigDecimal getLoanMny() {
        return loanMny;
    }

    public void setLoanMny(BigDecimal loanMny) {
        this.loanMny = loanMny;
    }
    public BigDecimal getDueRiskMny() {
        return dueRiskMny;
    }

    public void setDueRiskMny(BigDecimal dueRiskMny) {
        this.dueRiskMny = dueRiskMny;
    }
    public BigDecimal getPayRiskMny() {
        return payRiskMny;
    }

    public void setPayRiskMny(BigDecimal payRiskMny) {
        this.payRiskMny = payRiskMny;
    }
    public BigDecimal getQualityAccidentMny() {
        return qualityAccidentMny;
    }

    public void setQualityAccidentMny(BigDecimal qualityAccidentMny) {
        this.qualityAccidentMny = qualityAccidentMny;
    }
    public BigDecimal getSubcontractMny() {
        return subcontractMny;
    }

    public void setSubcontractMny(BigDecimal subcontractMny) {
        this.subcontractMny = subcontractMny;
    }
    public BigDecimal getSafeAccidentMny() {
        return safeAccidentMny;
    }

    public void setSafeAccidentMny(BigDecimal safeAccidentMny) {
        this.safeAccidentMny = safeAccidentMny;
    }
    public BigDecimal getReceivedMny() {
        return receivedMny;
    }

    public void setReceivedMny(BigDecimal receivedMny) {
        this.receivedMny = receivedMny;
    }
    public BigDecimal getCashMny() {
        return cashMny;
    }

    public void setCashMny(BigDecimal cashMny) {
        this.cashMny = cashMny;
    }
    public BigDecimal getOtherCashMny() {
        return otherCashMny;
    }

    public void setOtherCashMny(BigDecimal otherCashMny) {
        this.otherCashMny = otherCashMny;
    }
    public BigDecimal getAssessMny() {
        return assessMny;
    }

    public void setAssessMny(BigDecimal assessMny) {
        this.assessMny = assessMny;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<AssessCashDetailEntity> getAssessCashDetailList() {
        return assessCashDetailList;
    }

    public void setAssessCashDetailList(List<AssessCashDetailEntity> assessCashDetailList) {
        this.assessCashDetailList = assessCashDetailList;
    }

    public List<AssessCashDetailSumEntity> getAssessCashDetailSumList() {
        return assessCashDetailSumList;
    }

    public void setAssessCashDetailSumList(List<AssessCashDetailSumEntity> assessCashDetailSumList) {
        this.assessCashDetailSumList = assessCashDetailSumList;
    }
}
