package com.ejianc.business.jltest.margin.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeDetailEntity;
import com.ejianc.business.jltest.margin.bean.PaymentDetailsEntity;
import com.ejianc.business.jltest.margin.bean.RiskPayConfirmationEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeDetailService;
import com.ejianc.business.jltest.margin.service.IPaymentDetailsService;
import com.ejianc.business.jltest.margin.service.IRiskPayConfirmationService;
import com.ejianc.business.jltest.margin.vo.PaymentDetailsVO;
import com.ejianc.business.jltest.margin.vo.RiskPayConfirmationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 风险金缴纳确认
 *
 * @author generator
 */
@Controller
@RequestMapping("riskPayConfirmationTabsList")
public class SubmitRiskPayConfirmationController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Risk";//此处需要根据实际修改

    @Autowired
    private IRiskPayConfirmationService service;

    @Autowired
    private IPaymentDetailsService paymentDetailsService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IDirectEmployeeDetailService iDirectEmployeeDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RiskPayConfirmationVO> saveOrUpdate(@RequestBody RiskPayConfirmationVO saveOrUpdateVO) {
        RiskPayConfirmationEntity entity = BeanMapper.map(saveOrUpdateVO, RiskPayConfirmationEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        RiskPayConfirmationVO vo = BeanMapper.map(entity, RiskPayConfirmationVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RiskPayConfirmationVO> queryDetail(Long id) {
        RiskPayConfirmationEntity entity = service.selectById(id);
        RiskPayConfirmationVO vo = BeanMapper.map(entity, RiskPayConfirmationVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RiskPayConfirmationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RiskPayConfirmationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }

        List<Long> ids = vos.stream().map(RiskPayConfirmationVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            //根据先查 缴纳相详情
            LambdaQueryWrapper<RiskPayConfirmationEntity> wrapper1 = new LambdaQueryWrapper<>();
            wrapper1.eq(RiskPayConfirmationEntity::getId, id);

            //构建查询条件 查询员工明细表
            RiskPayConfirmationEntity one = service.getOne(wrapper1);
            LambdaQueryWrapper<DirectEmployeeDetailEntity> wrapper2 = new LambdaQueryWrapper<>();
            wrapper2.eq(DirectEmployeeDetailEntity::getId, one.getEmployeeDetailId());
            DirectEmployeeDetailEntity one1 = iDirectEmployeeDetailService.getOne(wrapper2);
            one1.setHasRecord(1);
            iDirectEmployeeDetailService.updateById(one1);
        }

        service.removeByIds(vos.stream().map(RiskPayConfirmationVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RiskPayConfirmationVO>> queryList(@RequestBody QueryParam param) {

/*
        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();
            // System.out.println("kkkkkkkkkkkkkkk :"+key);

            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();
            // System.out.println("vvvvvvvv:"+value1);
            if (key.equals("isok") && value1.equals("0")) {
                param.getParams().put("isok", new Parameter(QueryParam.EQ, 0));
            }
            if (key.equals("isok") && value1.equals("1")) {
                param.getParams().put("isok", new Parameter(QueryParam.EQ, 1));
            }
        }
*/

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("payableAmount");
        fuzzyFields.add("paymentDate");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        param.getParams().put("isok", new Parameter(QueryParam.EQ, 1));


        IPage<RiskPayConfirmationEntity> page = service.queryPage(param, false);
        IPage<RiskPayConfirmationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RiskPayConfirmationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList1", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RiskPayConfirmationVO>> queryList1(@RequestBody QueryParam param) {

/*
        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();
            // System.out.println("kkkkkkkkkkkkkkk :"+key);

            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();
            // System.out.println("vvvvvvvv:"+value1);
            if (key.equals("isok") && value1.equals("0")) {
                param.getParams().put("isok", new Parameter(QueryParam.EQ, 0));
            }
            if (key.equals("isok") && value1.equals("1")) {
                param.getParams().put("isok", new Parameter(QueryParam.EQ, 1));
            }
        }
*/

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("payableAmount");
        fuzzyFields.add("paymentDate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        param.getParams().put("isok", new Parameter(QueryParam.EQ, 1));


        IPage<RiskPayConfirmationEntity> page = service.queryPage(param, false);
        IPage<RiskPayConfirmationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RiskPayConfirmationVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("payableAmount");
        fuzzyFields.add("paymentDate");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RiskPayConfirmationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RiskPayConfirmation1-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRiskPayConfirmationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RiskPayConfirmationVO>> refRiskPayConfirmationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                   String condition,
                                                                                   String searchObject,
                                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RiskPayConfirmationEntity> page = service.queryPage(param, false);
        IPage<RiskPayConfirmationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RiskPayConfirmationVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

/*
    //自定义的更新事件
    @GetMapping("/updateB")
    @ResponseBody
    public CommonResponse updateB(String id) {
        try {
            RiskPayConfirmationEntity riskPayConfirmationEntity = service.selectById(id);
            riskPayConfirmationEntity.setIsok(1);//设置状态 为已确认
            riskPayConfirmationEntity.setSubmitter(sessionManager.getUserContext().getEmployeeName());
            riskPayConfirmationEntity.setConfirmTime(new Date());
            service.updateById(riskPayConfirmationEntity);
            return CommonResponse.success("数据更新成功");
        } catch (Exception e) {
            logger.error("updateB  id:{}", id, e);
        }
        return CommonResponse.error("数据更新失败");
    }*/


    /*批量更新数据*/
    @PostMapping("/updateB1")
    @ResponseBody
    public CommonResponse updateB1(@RequestBody String[] ids) {

        for (String id : ids) {
            try {
                RiskPayConfirmationEntity riskPayConfirmationEntity = service.selectById(id);
                riskPayConfirmationEntity.setIsok(1);//设置状态 为已确认
                PaymentDetailsEntity paymentDetailsEntity = paymentDetailsService.selectById(id);
                if (paymentDetailsEntity != null) {
                    paymentDetailsEntity.setConfirmationState(1); //设置确认状态
                    paymentDetailsService.updateById(paymentDetailsEntity);
                }
                riskPayConfirmationEntity.setSubmitter(sessionManager.getUserContext().getEmployeeName());
                riskPayConfirmationEntity.setConfirmTime(new Date());
                riskPayConfirmationEntity.setConfirmPerson(sessionManager.getUserContext().getEmployeeName());
                service.updateById(riskPayConfirmationEntity);
            } catch (Exception e) {
                logger.error("updateB  id:{}", id, e);
                return CommonResponse.error("数据更新失败");
            }
        }
        return CommonResponse.success("数据更新成功");
    }



    /*批量更新数据*/
    @PostMapping("/delete1")
    @ResponseBody
    public CommonResponse delete1(@RequestBody String[] ids) {

        for (String id : ids) {
            try {
                service.removeById(id);
            } catch (Exception e) {
                logger.error("updateB  id:{}", id, e);
                return CommonResponse.error("数据更新失败");
            }
        }
        return CommonResponse.success("数据更新成功");
    }

    @GetMapping("/selectByid")
    @ResponseBody
    public CommonResponse selectByid(String id) {

        System.out.println(id);
        RiskPayConfirmationEntity riskPayConfirmationEntity = service.selectById(id);
        Map<String, Object> map = new HashMap<>();
        map.put("name",riskPayConfirmationEntity.getConfirmPerson());
        map.put("time",riskPayConfirmationEntity.getConfirmTime());
        System.out.println("map:"+map);
        return CommonResponse.success("数据更新成功",map);
    }


}
