package com.ejianc.business.jltest.orgtest.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jltest.orgtest.bean.PlanaDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.service.IPlanaDetailService;
import com.ejianc.business.jltest.orgtest.service.IPlanaService;
import com.ejianc.business.jltest.orgtest.vo.PlanaDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlanaListVO;
import com.ejianc.business.jltest.orgtest.vo.PlanaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.business.jltest.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 安措费使用计划A
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("plana")
public class PlanaController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLAN_CODE";//此处需要根据实际修改

    @Autowired
    private IPlanaService service;
    @Autowired
    private IPlanaDetailService planaDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanaVO> saveOrUpdate(@RequestBody PlanaVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanaVO> queryDetail(Long id) {
    	PlanaEntity entity = service.selectById(id);
    	PlanaVO vo = BeanMapper.map(entity, PlanaVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanaVO> vos) {
        service.removeByIdsRewrite(vos);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanaListVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_id");
        fuzzyFields.add("employee_name");
        fuzzyFields.add("plana_name");
        //判断是否为当前登陆人
        if (param.getParams().get("employeeId") != null) {
            System.out.println("判断是否为当前登陆人"+param.getParams().get("employeeId").getValue());
            if ( param.getParams().get("employeeId").getValue().toString().equals("true")) {
                Long employeeId = sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlanaEntity> page = service.queryPage(param,false);
        IPage<PlanaListVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<PlanaListVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())){
            //属性映射
            resDatas = BeanMapper.mapList(page.getRecords(), PlanaListVO.class);
            //记录主表id
            List<Long> ids = new ArrayList<>();
            //给明细表赋值
            Map<Long,Integer> map = new HashMap<>();
            if(CollectionUtils.isNotEmpty(resDatas)) {
                //遍历主表数据获取主表Id 和  明细表需要得值（单据状态）
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper<PlanaDetailEntity> lambda = Wrappers.<PlanaDetailEntity>lambdaQuery();
            lambda.in(PlanaDetailEntity::getPlanaId,ids);
            //获取明细表
            List<PlanaDetailEntity> resList = planaDetailService.list(lambda);
            //转换
            List<PlanaListVO> planaListVOList = BeanMapper.mapList(resList, PlanaListVO.class);
            if(CollectionUtils.isNotEmpty(planaListVOList)){
                planaListVOList.forEach(e->{

                    //遍历明细表  给明细表赋值
                    e.setBillState(map.get(e.getPlanaId()));
                    e.setPlanaMny(e.getDetailMny());

                    logger.info("明细表id："+e.getId()+"PlanId："+e.getPlanaId()+
                            "orgName"+e.getOrgName()+"billState"+e.getBillState()+
                            "planaMny"+e.getPlanaMny()+"detailMny"+e.getDetailMny());
                });

                resDatas.addAll(planaListVOList);
            }
        }



        pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("org_id");
        fuzzyFields.add("employee_name");
        fuzzyFields.add("plana_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        //判断是否为当前登陆人
        if (param.getParams().get("employeeId") != null) {
            System.out.println("判断是否为当前登陆人"+param.getParams().get("employeeId").getValue());
            if ( param.getParams().get("employeeId").getValue().toString().equals("true")) {
                Long employeeId = sessionManager.getUserContext().getEmployeeId();
                param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
            } else {
                param.getParams().remove("employeeId");
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanaEntity> list = service.queryList(param);
        List<PlanaListVO> planaListVOS = BeanMapper.mapList(list,PlanaListVO.class);
        //新建一个Vo存储数据
        List<PlanaListVO> resDatas = new ArrayList<>();
        //遍历Vo  加上每一个明细表
        for (PlanaListVO p : planaListVOS) {
            switch (p.getPlanaUrgency()){
                case 1:p.setUrgencyName("特急") ; break;
                case 2:p.setUrgencyName("急"); break;
                case 3:p.setUrgencyName("一般"); break;
            }
            switch (p.getPlanaSecret()){
                case 1:p.setUrgencyName("公开"); break;
                case 2:p.setUrgencyName("秘密"); break;
                case 3:p.setUrgencyName("机密"); break;
                case 4:p.setUrgencyName("绝密"); break;
            }
            logger.info("明细表id："+p.getId()+"PlanId："+p.getPlanaId()+
                    "orgName"+p.getOrgName()+"billState"+p.getBillState()+
                    "planaMny"+p.getPlanaMny()+"detailMny"+p.getDetailMny());
            resDatas.add(p);
            QueryWrapper queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("plana_id",p.getId());
            List<PlanaDetailEntity> list1 = planaDetailService.list(queryWrapper);

            List<PlanaListVO> detailList = BeanMapper.mapList(list1,PlanaListVO.class);
            if (CollectionUtils.isNotEmpty(detailList)){
                for (PlanaListVO detail:detailList) {
                    detail.setPlanaMny(detail.getDetailMny());
                    logger.info("明细表id："+detail.getId()+"PlanId："+detail.getPlanaId()+
                            "orgName"+detail.getOrgName()+"billState"+detail.getBillState()+
                            "planaMny"+detail.getPlanaMny()+"detailMny"+detail.getDetailMny());
                    resDatas.add(detail);
                }
            }


        }

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Plana-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPlanaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanaVO>> refPlanaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

        }

        IPage<PlanaEntity> page = service.queryPage(param,false);
        IPage<PlanaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanaVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PlanaDetail-import.xlsx", "安措费计划A明细模板");
    }
    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlanaDetailVO> successList = new ArrayList<>();
        List<PlanaDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //获取物资档案数据
//                List<String> materialCodeList = new ArrayList<>();
//                Map<String,MaterialVO> map = new HashMap<>();
//                for (int i = 1; i < result.size(); i++) {
//                    List<String> datas = result.get(i);
//                    materialCodeList.add(datas.get(0));//取材料编码  用来校验
//                }
//                CommonResponse<List<MaterialVO>> materialRes =  materialApi.queryMaterialListByCodes(materialCodeList);
//                if(!materialRes.isSuccess()){
//                    return CommonResponse.error(materialRes.getMsg());
//                }
//                map = materialRes.getData().stream().collect(Collectors.toMap(p -> p.getCode(), Function.identity()));
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlanaDetailVO detailVO = new PlanaDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    //给安全费用项目名称赋值
                    String dtailName = datas.get(0);
                    detailVO.setDetailName(dtailName);
//                    if(map.containsKey(materialCode)){
//                        MaterialVO materialVO =   map.get(materialCode);
//                        detailVO.setMaterialTypeId(materialVO.getCategoryId());
//                        detailVO.setMaterialTypeName(materialVO.getCategoryName());
//                        detailVO.setMaterialId(materialVO.getId());
//                        detailVO.setMaterialName(materialVO.getName());
//                        detailVO.setSpec(materialVO.getSpec());
//                        detailVO.setUnitId(materialVO.getUnitId());
//                        detailVO.setUnitName(materialVO.getUnitName());
//                    }else{
//                        detailVO.setErrorMsg("材料编码不匹配！");
//                        errorList.add(detailVO);
//                        continue;
//                    }
                    //拟投入金额（万元）  校验赋值
                    try {

                        String detailMny = datas.get(1);
                        detailVO.setDetailMny(StringUtils.isNotBlank(detailMny) ? new BigDecimal(detailMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("拟投入金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //最大拟投入金额  校验赋值
                    try {
                        String detailMaxMny = datas.get(2);  //todo 下拉 ？？
                        detailVO.setDetailMaxMny(StringUtils.isNotBlank(detailMaxMny) ? new BigDecimal(detailMaxMny) : null);
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("最高价格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //校验大小
                    try {
                        String detailMny = datas.get(1);
                        String detailMaxMny = datas.get(2);
                        if (new BigDecimal(detailMaxMny).doubleValue()<new BigDecimal(detailMny).doubleValue()){
                            throw new Exception("最高价格小于最低价！");
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("最高价格小于最低价！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //组织名称  组织Id赋值
                    try {
                        String orgName = datas.get(3);
                        CommonResponse<OrgVO> byNameAndTenantId = iOrgApi.findByNameAndTenantId(orgName, InvocationInfoProxy.getTenantid());
                        if (ObjectUtils.isEmpty(byNameAndTenantId)){
                            throw new Exception("没有此组织！");
                        }
                        detailVO.setOrgName(orgName);
                        detailVO.setOrgId(byNameAndTenantId.getData().getId());
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("没有此组织！");
                        errorList.add(detailVO);
                        continue;
                    }
                    //集团类型赋值
                    try {
                        String orgType = datas.get(4);
                        if (orgType.equals("集团")){
                            detailVO.setOrgType(1);
                        }else if (orgType.equals("分公司")){
                            detailVO.setOrgType(2);
                        }else if (orgType.equals("项目部")){
                            detailVO.setOrgType(3);
                        }else {
                            throw new Exception("没有此集团！");
                        }
                    }
                    catch (Exception e) {
                        detailVO.setErrorMsg("没有此集团！");
                        errorList.add(detailVO);
                        continue;
                    }

                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
