package com.ejianc.business.jltest.orgtest.controller;

import java.io.Serializable;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.PlancDetailEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteamcEntity;
import com.ejianc.business.jltest.orgtest.service.IPlancDetailService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamcService;
import com.ejianc.business.jltest.orgtest.vo.PlancDetailVO;
import com.ejianc.business.jltest.orgtest.vo.PlancListVO;
import com.ejianc.business.jltest.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jltest.orgtest.bean.PlancEntity;
import com.ejianc.business.jltest.orgtest.service.IPlancService;
import com.ejianc.business.jltest.orgtest.vo.PlancVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 安措费使用计划C
 *
 * @author generator
 */
@Controller
@RequestMapping("planc")
public class PlancController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PLANC_CODE";//此处需要根据实际修改

    @Autowired
    private ISafeteamcService safeteamcService;

    @Autowired
    private IPlancService service;

    @Autowired
    private IPlancDetailService plancDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlancVO> saveOrUpdate(@RequestBody PlancVO saveOrUpdateVO) {
        PlancEntity entity = BeanMapper.map(saveOrUpdateVO, PlancEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        Long safeteamcId = entity.getSafeteamcId();
        SafeteamcEntity safeteamc = safeteamcService.getById(safeteamcId);
        safeteamc.setPlancFlag(2);
        safeteamcService.updateById(safeteamc);
        service.saveOrUpdate(entity, false);
        PlancVO vo = BeanMapper.map(entity, PlancVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlancVO> queryDetail(Long id) {
        PlancEntity entity = service.selectById(id);
        PlancVO vo = BeanMapper.map(entity, PlancVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlancVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlancVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(PlancVO::getSafeteamcId).collect(Collectors.toList());
        Collection<SafeteamcEntity> safeteamcEntities = safeteamcService.listByIds(ids);
        for (SafeteamcEntity safeteamc : safeteamcEntities) {
            safeteamc.setPlancFlag(1);
        }
        safeteamcService.updateBatchById(safeteamcEntities);
        service.removeByIds(vos.stream().map(PlancVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlancListVO>> queryList(@RequestBody QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        Parameter lister = params.remove("islister");
        if (!ObjectUtil.isEmpty(lister)) {
            if ("1".equals(lister.getValue())) {
                params.put("listerId", new Parameter("eq", sessionManager.getUserContext().getEmployeeId()));
            }
        }
        param.setParams(params);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlancEntity> page = service.queryPage(param, false);
        IPage<PlancListVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlancListVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), PlancListVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }

            LambdaQueryWrapper<PlancDetailEntity> lambda = Wrappers.<PlancDetailEntity>lambdaQuery();
            lambda.in(PlancDetailEntity::getPlanId, ids);
            List<PlancDetailEntity> resList = plancDetailService.list(lambda);
            List<PlancListVO> plancDetailVOList = BeanMapper.mapList(resList, PlancListVO.class);
            if (CollectionUtils.isNotEmpty(plancDetailVOList)) {
                plancDetailVOList.forEach(e -> {
                    e.setBillState(map.get(e.getPlanId()));
                    e.setPlanMny(e.getDetailMny());
                    e.setOrgName(e.getDetailOrgName());
                    e.setPlanName(e.getDetailName());
                });

                resDatas.addAll(plancDetailVOList);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success("查询列表数据成功！", pageData);
        } else {
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlancListVO.class));
            return CommonResponse.success("查询列表数据成功！", pageData);
        }

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlancEntity> list = service.queryList(param);
        List<PlancListVO> resDatas = new ArrayList<>();
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            resDatas = BeanMapper.mapList(list, PlancListVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }

            LambdaQueryWrapper<PlancDetailEntity> lambda = Wrappers.<PlancDetailEntity>lambdaQuery();
            lambda.in(PlancDetailEntity::getPlanId, ids);
            List<PlancDetailEntity> resList = plancDetailService.list(lambda);
            List<PlancListVO> plancDetailVOList = BeanMapper.mapList(resList, PlancListVO.class);

            if (CollectionUtils.isNotEmpty(plancDetailVOList)) {
                plancDetailVOList.forEach(e -> {
                    e.setBillState(map.get(e.getPlanId()));
                    e.setPlanName(e.getDetailName());
                    e.setPlanMny(e.getDetailMny());
                    e.setOrgName(e.getDetailOrgName());
                    e.setPlanName(e.getDetailName());
                });

                resDatas.addAll(plancDetailVOList);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);

            beans.put("records", resDatas);
        } else {
            beans.put("records", resDatas);
        }
        //todo:字段翻译等等
        for (PlancListVO entity : resDatas) {
            switch (entity.getUrgencyDegree()) {
                case 1:
                    entity.setUrgencyDegreeName("一般");
                    break;
                case 2:
                    entity.setUrgencyDegreeName("急");
                    break;
                case 3:
                    entity.setUrgencyDegreeName("特急");
                    break;
            }
            switch (entity.getSecurityClass()) {
                case 1:
                    entity.setSecurityClassName("公开");
                    break;
                case 2:
                    entity.setSecurityClassName("秘密");
                    break;
                case 3:
                    entity.setSecurityClassName("机密");
                    break;
                case 4:
                    entity.setSecurityClassName("绝密");
                    break;
            }
        }
        ExcelExport.getInstance().export("Planc-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlancData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlancVO>> refPlancData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlancEntity> page = service.queryPage(param, false);
        IPage<PlancVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlancVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInfo")
    @ResponseBody
    public void downloadMaterial(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PlancDetail-import.xlsx", "明细模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlancDetailVO> successList = new ArrayList<>();
        List<PlancDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlancDetailVO detailVO = new PlancDetailVO();
                    detailVO.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                    String detailName = datas.get(0);
                    // 安全费用项目名称验证
                    if (StringUtils.isEmpty(detailName)) {
                        detailVO.setErrorMsg("安全费用项目名称为空");
                        errorList.add(detailVO);
                        continue;
                    } else {
                        detailVO.setDetailName(detailName);
                    }
                    // 拟投入金额验证
                    try {
                        String detailMny = datas.get(1);
                        detailVO.setDetailMny(StringUtils.isNotBlank(detailMny) ? new BigDecimal(detailMny) : null);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("拟投入金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    // 最大拟投入金额验证
                    try {
                        String detailMaxMny = datas.get(2);  //todo 下拉 ？？
                        detailVO.setDetailMaxMny(StringUtils.isNotBlank(detailMaxMny) ? new BigDecimal(detailMaxMny) : null);
                    } catch (Exception e) {
                        detailVO.setErrorMsg("最大拟投入金额格式错误！");
                        errorList.add(detailVO);
                        continue;
                    }
                    if (detailVO.getDetailMny().compareTo(detailVO.getDetailMaxMny()) > 0) {
                        detailVO.setErrorMsg("拟投入金额超出最大金额！");
                        errorList.add(detailVO);
                        continue;
                    }
                    // 组织验证
                    String orgName = datas.get(3);
                    CommonResponse<OrgVO> orgResult = iOrgApi.findByNameAndTenantId(orgName, 999999L);
                    if (!orgResult.isSuccess()) {
                        detailVO.setErrorMsg("组织不存在！");
                        errorList.add(detailVO);
                        continue;
                    }
                    OrgVO orgVO = orgResult.getData();
                    if (ObjectUtil.isEmpty(orgVO)) {
                        detailVO.setErrorMsg("组织不存在！");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setDetailOrgId(orgVO.getId());
                    detailVO.setDetailOrgName(orgVO.getName());

                    String orgType = datas.get(4);
                    if (orgType.equals("集团")) {
                        detailVO.setDetailOrgType(1);
                    } else if (orgType.equals("分公司")) {
                        detailVO.setDetailOrgType(2);
                    } else if (orgType.equals("项目部")) {
                        detailVO.setDetailOrgType(3);
                    } else {
                        detailVO.setErrorMsg("组织类型不存在" + orgType + "！");
                        errorList.add(detailVO);
                        continue;
                    }

                    successList.add(detailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
