package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jltest.orgtest.bean.DangeraEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.service.IDangeraService;
import com.ejianc.business.jltest.orgtest.service.IPlanaService;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.vo.DangeraVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import groovy.util.logging.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service("plana")
@Slf4j
public class PlanaBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISafeTeamaService safeTeamaService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IPlanaService planaService;
	@Autowired
	private IDangeraService dangeraService;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private SessionManager sessionManager;
	private static final String BILL_CODE = "DANGER_CODE";//此处需要根据实际修改

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO


        return CommonResponse.success();
    }

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO提交后上游数据的状态改为1 增加提交人 提交日期参数 生成  重大事故隐患判断 (自由态)
				PlanaEntity plana = planaService.getById(billId);
		if (state==1){
			logger.info("增加提交人 提交日期参数");
//			//增加提交人 提交日期参数

			plana.setSubmitPeopleId(sessionManager.getUserContext().getEmployeeId());
			plana.setSubmitPeopleName(sessionManager.getUserContext().getEmployeeName());
			plana.setSubmitDate(new Date());
			planaService.updateById(plana);

		}
				logger.info("更改上游数据信息");
				//更改上游数据信息
				SafeTeamaEntity safeTeama = safeTeamaService.selectById(plana.getSafeteamaId());
				safeTeama.setMeetingFlag(1);
				safeTeamaService.updateById(safeTeama);
				logger.info("生成  重大事故隐患判断 (自由态)");
				// 生成  重大事故隐患判断 (自由态)
				DangeraVO dangeraVO = new DangeraVO();
				dangeraVO.setOrgId(plana.getOrgId());
				dangeraVO.setOrgName(plana.getOrgName());
				dangeraVO.setOrgCode(plana.getOrgCode());
				dangeraVO.setDangeraName(plana.getPlanaName());
				dangeraVO.setDangeraDate(plana.getPlanaDate());
				dangeraVO.setEmployeeId(plana.getEmployeeId());
				dangeraVO.setEmployeeName(plana.getEmployeeName());
				dangeraVO.setDepartmentId(plana.getDepartmentId());
				dangeraVO.setDepartmentName(plana.getDepartmentName());
				dangeraVO.setCreateTime(new Date());
				dangeraVO.setDangerType(1);
				dangeraVO.setPlanId(plana.getId());
				DangeraEntity dangera = BeanMapper.map(dangeraVO, DangeraEntity.class);
				BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), dangeraVO);
				CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);

				dangera.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				dangeraService.saveOrUpdate(dangera,false);

				logger.info("复制附件");
				attachmentApi.copyFilesFromSourceBillToTargetBill(plana.getId().toString(),"EJCBT202403000025","plana2",dangera.getId().toString(),"EJCBT202403000026","dangera2");


        ////		LambdaQueryWrapper<PlanaEntity> queryWrapper = new LambdaQueryWrapper<>();
        ////		queryWrapper.eq(PlanaEntity::get)
        ////		planaService.list()
        return CommonResponse.success();
    }

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 判断下游数据状态 不为 1 和  0 全部撤回
		LambdaQueryWrapper<DangeraEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(DangeraEntity::getPlanId,billId);
		queryWrapper.eq(DangeraEntity::getDangerType,1);
		queryWrapper.eq(DangeraEntity::getDr,0);
		DangeraEntity dangera = dangeraService.getOne(queryWrapper);
		if (!ObjectUtils.isEmpty(dangera)){
			//下游状态不为1或者3  中游数据撤回(自由态)  下游数据删除
			if (dangera.getBillState()!=1&&dangera.getBillState()!=3){
				//中游数据撤回(自由态)
				PlanaEntity planaEntity = planaService.getById(billId);
				planaEntity.setBillState(0);
				planaService.updateById(planaEntity);
				//下游数据删除
//				dangera.setDr(1);
				dangeraService.removeById(dangera.getId());
//				dangeraService.updateById(dangera);
			}else {
				return CommonResponse.error("当前单子已存在下游数据，不能删除");
			}
		}else {
			return CommonResponse.error("没有生成对应数据");
		}

		PlanaEntity plana = planaService.getById(billId);
		SafeTeamaEntity safeTeama = safeTeamaService.getById(plana.getSafeteamaId());
		safeTeama.setMeetingFlag(2);
		safeTeamaService.updateById(safeTeama);
		return CommonResponse.success();
	}

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
