package com.ejianc.business.jltest.orgtest.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeteamdEntity;
import com.ejianc.business.jltest.orgtest.service.ISafeTeamaService;
import com.ejianc.business.jltest.orgtest.service.ISafeteamdService;
import com.ejianc.business.jltest.orgtest.vo.PlandVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jltest.orgtest.mapper.PlandMapper;
import com.ejianc.business.jltest.orgtest.bean.PlandEntity;
import com.ejianc.business.jltest.orgtest.service.IPlandService;

import java.util.ArrayList;
import java.util.List;

/**
 * 安措费使用计划D
 * 
 * @author generator
 * 
 */
@Service("plandService")
public class PlandServiceImpl extends BaseServiceImpl<PlandMapper, PlandEntity> implements IPlandService{
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISafeteamdService safeteamdService;

    private static final String BILL_CODE = "PLAND_CODE";//此处需要根据实际修改
    @Override
    public PlandVO saveUpdate(PlandVO saveOrUpdateVO) {
        PlandEntity entity = BeanMapper.map(saveOrUpdateVO, PlandEntity.class);


        LambdaQueryWrapper<PlandEntity> lambda = Wrappers.<PlandEntity>lambdaQuery();
        lambda.eq(PlandEntity::getOrgId, saveOrUpdateVO.getOrgId());
        if(entity.getId() != null){
            lambda.ne(PlandEntity::getId, saveOrUpdateVO.getId());
        }
        lambda.notIn(PlandEntity::getBillState, 1,3);
        List<PlandEntity> entityList =super.list(lambda);
        if(CollectionUtils.isNotEmpty(entityList)){
            throw new BusinessException("当前组织存在未生效的单据，不允许新增");
        }


        if((entity.getId() == null || entity.getId() == 0)&& StringUtils.isEmpty(entity.getBillCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        super.saveOrUpdate(entity, false);

        LambdaUpdateWrapper<SafeteamdEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SafeteamdEntity::getId, saveOrUpdateVO.getSafeteamdId());
        updateWrapper.set(SafeteamdEntity::getPlanFlag,2);
        safeteamdService.update(updateWrapper);


        PlandVO vo = BeanMapper.map(entity, PlandVO.class);
        return vo;
    }
}
