package com.ejianc.business.jltest.margin.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jltest.margin.bean.DirectPaidEmployeeEntity;
import com.ejianc.business.jltest.margin.bean.DirectPaidRecordEntity;
import com.ejianc.business.jltest.margin.bean.DirectAllocationRecordEntity;

/**
 * 直管部风险金台账
 *
 * @author generator
 */
@TableName("ejc_jltest_direct_ledger")
public class DirectLedgeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value = "direct_employee_id")
    private Long directEmployeeId;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "org_code")
    private String orgCode; // 组织code
    @TableField(value = "year")
    private Integer year; // 所属年度
    @TableField(value = "payable_mny")
    private BigDecimal payableMny; // 应缴纳金额
    @TableField(value = "accumulated_mny")
    private BigDecimal accumulatedMny; // 累计缴纳金额
    @TableField(value = "return_mny")
    private BigDecimal returnMny;
    @TableField(value = "actual_mny")
    private BigDecimal actualMny; // 实际缴纳金额
    @TableField(value = "allotment_mny")
    private BigDecimal allotmentMny; // 已分配金额
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist = false)
    @SubEntity(serviceName = "directPaidEmployeeService", pidName = "directLedgeId")
    private List<DirectPaidEmployeeEntity> directPaidEmployeeList = new ArrayList<>(); // 直管部台账缴纳人员
    @TableField(exist = false)
    @SubEntity(serviceName = "directPaidRecordService", pidName = "directLedgeId")
    private List<DirectPaidRecordEntity> directPaidRecordList = new ArrayList<>(); // 直管部台账缴纳记录
    @TableField(exist = false)
    @SubEntity(serviceName = "directAllocationRecordService", pidName = "directLedgeId")
    private List<DirectAllocationRecordEntity> directAllocationRecordList = new ArrayList<>(); // 直管部台账分配记录


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }

    public BigDecimal getAccumulatedMny() {
        return accumulatedMny;
    }

    public void setAccumulatedMny(BigDecimal accumulatedMny) {
        this.accumulatedMny = accumulatedMny;
    }

    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }

    public BigDecimal getAllotmentMny() {
        return allotmentMny;
    }

    public void setAllotmentMny(BigDecimal allotmentMny) {
        this.allotmentMny = allotmentMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<DirectPaidEmployeeEntity> getDirectPaidEmployeeList() {
        return directPaidEmployeeList;
    }

    public void setDirectPaidEmployeeList(List<DirectPaidEmployeeEntity> directPaidEmployeeList) {
        this.directPaidEmployeeList = directPaidEmployeeList;
    }

    public List<DirectPaidRecordEntity> getDirectPaidRecordList() {
        return directPaidRecordList;
    }

    public void setDirectPaidRecordList(List<DirectPaidRecordEntity> directPaidRecordList) {
        this.directPaidRecordList = directPaidRecordList;
    }

    public List<DirectAllocationRecordEntity> getDirectAllocationRecordList() {
        return directAllocationRecordList;
    }

    public void setDirectAllocationRecordList(List<DirectAllocationRecordEntity> directAllocationRecordList) {
        this.directAllocationRecordList = directAllocationRecordList;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }

    public Long getDirectEmployeeId() {
        return directEmployeeId;
    }

    public void setDirectEmployeeId(Long directEmployeeId) {
        this.directEmployeeId = directEmployeeId;
    }
}
