package com.ejianc.business.jltest.margin.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.jltest.margin.bean.InspiritLossDetailEntity;
/**
 * 激励/补亏分配详情
 *
 * @author generator
 *
 */
 @TableName("ejc_jltest_inspirit_loss")
public class InspiritLossEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 激励补亏分配编号
    @TableField(value="belongs_time")
    private Date belongsTime; // 所属年度
    @TableField(value="standard_id")
    private Long standardId; // 标准表
    @TableField(value="standard_name")
    private String standardName; // 标准表名称
    @TableField(value="standard_code")
    private String standardCode; // 标准表code
    @TableField(value="cash_id")
    private Long cashId; // 兑现审批表
    @TableField(value="cash_name")
    private String cashName; // 兑现审批表名称
    @TableField(value="cash_code")
    private String cashCode; // 兑现审批表code
    @TableField(value="cash_mny")
    private BigDecimal cashMny; //  考核兑现金额
    @TableField(value="issue_assess_mny")
    private BigDecimal issueAssessMny; //  本期分配总金额
    @TableField(value="issue_assess_sum_mny")
    private BigDecimal issueAssessSumMny; //  本期分配总金额
    @TableField(value="cash_node")
    private String cashNode; //  绩效激励/补亏节点
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="parent_org_name")
    private String parentOrgName; //
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）


    @TableField(exist=false)
    @SubEntity(serviceName="inspiritLossDetailService",pidName = "inspiritId")
    private List<InspiritLossDetailEntity> inspiritLossDetailList = new ArrayList<>(); // 激励补亏分配详情明细

    public BigDecimal getIssueAssessSumMny() {
        return issueAssessSumMny;
    }

    public void setIssueAssessSumMny(BigDecimal issueAssessSumMny) {
        this.issueAssessSumMny = issueAssessSumMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getBelongsTime() {
        return belongsTime;
    }

    public void setBelongsTime(Date belongsTime) {
        this.belongsTime = belongsTime;
    }
    public Long getStandardId() {
        return standardId;
    }

    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }
    public String getStandardName() {
        return standardName;
    }

    public void setStandardName(String standardName) {
        this.standardName = standardName;
    }
    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }
    public Long getCashId() {
        return cashId;
    }

    public void setCashId(Long cashId) {
        this.cashId = cashId;
    }
    public String getCashName() {
        return cashName;
    }

    public void setCashName(String cashName) {
        this.cashName = cashName;
    }
    public String getCashCode() {
        return cashCode;
    }

    public void setCashCode(String cashCode) {
        this.cashCode = cashCode;
    }
    public BigDecimal getCashMny() {
        return cashMny;
    }

    public void setCashMny(BigDecimal cashMny) {
        this.cashMny = cashMny;
    }
    public BigDecimal getIssueAssessMny() {
        return issueAssessMny;
    }

    public void setIssueAssessMny(BigDecimal issueAssessMny) {
        this.issueAssessMny = issueAssessMny;
    }
    public String getCashNode() {
        return cashNode;
    }

    public void setCashNode(String cashNode) {
        this.cashNode = cashNode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public List<InspiritLossDetailEntity> getInspiritLossDetailList() {
        return inspiritLossDetailList;
    }

    public void setInspiritLossDetailList(List<InspiritLossDetailEntity> inspiritLossDetailList) {
        this.inspiritLossDetailList = inspiritLossDetailList;
    }
}
