package com.ejianc.business.jltest.margin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.ejianc.business.jltest.margin.bean.DirectEmployeeEntity;
import com.ejianc.business.jltest.margin.bean.DirectStandardEntity;
import com.ejianc.business.jltest.margin.service.IDirectEmployeeService;
import com.ejianc.business.jltest.margin.service.IDirectStandardService;
import com.ejianc.business.jltest.orgtest.bean.DangeraEntity;
import com.ejianc.business.jltest.orgtest.bean.PlanaEntity;
import com.ejianc.business.jltest.orgtest.bean.SafeTeamaEntity;
import com.ejianc.foundation.support.api.IBillTypeApi;
import groovy.util.logging.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;

@Service("directStandard")
@Slf4j
public class DirectStandardBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDirectEmployeeService employeeService;
    @Autowired
    private IDirectStandardService standardService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        //TODO 判断下游数据状态 不为 1 和  0 全部撤回
        LambdaQueryWrapper<DirectEmployeeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DirectEmployeeEntity::getStandardId, billId);
        queryWrapper.eq(DirectEmployeeEntity::getDr, 0);
        DirectEmployeeEntity directEmployee = employeeService.getOne(queryWrapper);
        if (!ObjectUtils.isEmpty(directEmployee)) {
            //下游状态不为1或者3  中游数据撤回(自由态)  下游数据删除
            if (directEmployee.getBillState() != 1 && directEmployee.getBillState() != 3) {
                //中游数据撤回(自由态)
                DirectStandardEntity directStandard = standardService.getById(billId);
                directStandard.setBillState(0);
                standardService.updateById(directStandard);
                //下游数据删除
//				dangera.setDr(1);
                employeeService.removeById(directEmployee.getId());
//				dangeraService.updateById(dangera);
            } else {
                return CommonResponse.error("当前单子已存在下游数据，不能删除");
            }
        }
        // 撤回后  上游数据flag状态改为2
        logger.info("撤回后  上游数据flag状态改为2");
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
