/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jltest.margin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jltest.margin.bean.AssessCashDetailEntity;
import com.ejianc.business.jltest.margin.bean.AssessCashDetailSumEntity;
import com.ejianc.business.jltest.margin.bean.AssessCashEntity;
import com.ejianc.business.jltest.margin.bean.CashAmountEntity;
import com.ejianc.business.jltest.margin.bean.CashEntity;
import com.ejianc.business.jltest.margin.mapper.AssessCashMapper;
import com.ejianc.business.jltest.margin.service.IAssessCashService;
import com.ejianc.business.jltest.margin.service.ICashAmountService;
import com.ejianc.business.jltest.margin.service.ICashService;
import com.ejianc.business.jltest.margin.vo.AssessCashVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assessCashService")
public class AssessCashServiceImpl
extends BaseServiceImpl<AssessCashMapper, AssessCashEntity>
implements IAssessCashService {
    private static final String BILL_CODE = "ASSESS-CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICashService cashService;
    @Autowired
    private ICashAmountService cashAmountService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public AssessCashVO saveUpdate(AssessCashVO saveOrUpdateVO) {
        LambdaUpdateWrapper updateWrapper;
        List<AssessCashDetailSumEntity> cashDetailSumEntityList;
        List<AssessCashDetailEntity> assessCashDetailList;
        AssessCashEntity entity = (AssessCashEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AssessCashEntity.class));
        if (entity.getId() == null || entity.getId() == 0L && StringUtils.isEmpty((String)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() != null && entity.getId() != 0L) {
            assessCashDetailList = ((AssessCashEntity)((Object)super.selectById((Serializable)entity.getId()))).getAssessCashDetailList();
            this.logger.info("\u8981\u6c42\u6539\u7684\u6570\u636e\u6570\u91cf" + assessCashDetailList.size());
            for (AssessCashDetailEntity assessCashDetailEntity : assessCashDetailList) {
                LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
                updateWrapper2.eq(BaseEntity::getId, (Object)assessCashDetailEntity.getCashId());
                updateWrapper2.set(CashEntity::getFlag, (Object)0);
                this.cashService.update((Wrapper)updateWrapper2);
            }
            cashDetailSumEntityList = ((AssessCashEntity)((Object)super.selectById((Serializable)entity.getId()))).getAssessCashDetailSumList();
            this.logger.info("\u8981\u6c42\u6539\u7684\u6570\u636e\u6570\u91cf\u6c47\u603b" + cashDetailSumEntityList.size());
            for (AssessCashDetailSumEntity cashDetail : cashDetailSumEntityList) {
                updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)cashDetail.getCashSumId());
                updateWrapper.set(CashAmountEntity::getFlag, (Object)0);
                this.cashAmountService.update((Wrapper)updateWrapper);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        assessCashDetailList = entity.getAssessCashDetailList();
        for (AssessCashDetailEntity assessCashDetailEntity : assessCashDetailList) {
            LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
            updateWrapper2.eq(BaseEntity::getId, (Object)assessCashDetailEntity.getCashId());
            updateWrapper2.set(CashEntity::getFlag, (Object)1);
            this.cashService.update((Wrapper)updateWrapper2);
        }
        cashDetailSumEntityList = entity.getAssessCashDetailSumList();
        for (AssessCashDetailSumEntity cashDetail : cashDetailSumEntityList) {
            updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)cashDetail.getCashSumId());
            updateWrapper.set(CashAmountEntity::getFlag, (Object)1);
            this.cashAmountService.update((Wrapper)updateWrapper);
        }
        AssessCashVO assessCashVO = (AssessCashVO)BeanMapper.map((Object)((Object)entity), AssessCashVO.class);
        return assessCashVO;
    }

    @Override
    public void removeByIdUpdateDetail(List<AssessCashVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssessCashVO assessCashVO : vos) {
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        Collection assessCashEntities = super.listByIds(ids);
        for (AssessCashEntity assessCashEntity : assessCashEntities) {
            List<AssessCashDetailEntity> assessCashDetailList = assessCashEntity.getAssessCashDetailList();
            for (AssessCashDetailEntity cashDetail : assessCashDetailList) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)cashDetail.getCashId());
                updateWrapper.set(CashEntity::getFlag, (Object)0);
                this.cashService.update((Wrapper)updateWrapper);
            }
            List<AssessCashDetailSumEntity> assessCashDetailSumList = assessCashEntity.getAssessCashDetailSumList();
            for (AssessCashDetailSumEntity cashDetailSum : assessCashDetailSumList) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)cashDetailSum.getCashSumId());
                updateWrapper.set(CashAmountEntity::getFlag, (Object)0);
                this.cashAmountService.update((Wrapper)updateWrapper);
            }
        }
        super.removeByIds(ids, true);
    }
}

