package com.ejianc.job.admin.hystrix;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.job.admin.api.IJobAdminApi;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class JobAdminHystrix implements IJobAdminApi {
    /**
     * 新增调度任务
     *
     * @param jobInfo
     * @return
     */
    @Override
    public CommonResponse<XxlJobInfo> add(XxlJobInfo jobInfo) {
        return CommonResponse.error("网络问题，新增调度任务失败。");
    }

    /**
     * 修改调度任务
     *
     * @param jobInfo
     * @return
     */
    @Override
    public CommonResponse<String> update(XxlJobInfo jobInfo) {
        return CommonResponse.error("网络问题，修改调度任务失败。");
    }

    /**
     * 执行一次调度任务
     *
     * @param id
     * @param executorParam
     * @return
     */
    @Override
    public CommonResponse<String> triggerJob(int id, String executorParam) {
        return CommonResponse.error("网络问题，执行调度任务失败。");
    }

    /**
     * 查询一条调度任务
     *
     * @param id
     * @return
     */
    @Override
    public CommonResponse<XxlJobInfo> queryOne(Integer id) {
        return CommonResponse.error("网络问题，查询调度任务失败。");
    }

    /**
     * 删除调度任务
     *
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> remove(Integer id) {
        return CommonResponse.error("网络问题，删除调度任务失败。");
    }

    /**
     * 启动调度任务
     *
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> start(Integer id) {
        return CommonResponse.error("网络问题，启动调度任务失败。");
    }

    /**
     * 停止调度任务
     *
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> stop(Integer id) {
        return CommonResponse.error("网络问题，停止调度任务失败。");
    }

    /**
     * 新增调度任务执行器
     *
     * @param group
     * @return
     */
    @Override
    public CommonResponse<XxlJobGroup> addGroup(XxlJobGroup group) {
        return  CommonResponse.error("网络问题，新增调度任务执行器失败。");
    }

    /**
     * 更新调度任务执行器
     *
     * @param group
     * @return
     */
    @Override
    public CommonResponse<String> updateGroup(XxlJobGroup group) {
        return CommonResponse.error("网络问题，更新调度任务执行器失败。");
    }

    /**
     * 查询执行器列表
     *
     * @return
     */
    @Override
    public CommonResponse<List<XxlJobGroup>> queryGroupList() {
        return CommonResponse.error("网络问题，查询执行器列表失败。");
    }

    /**
     * 删除执行器
     *
     * @param id
     * @return
     */
    @Override
    public CommonResponse<String> removeGroup(Integer id) {
        return CommonResponse.error("网络问题，删除执行器失败。");
    }

    /**
     * 分页查询调度任务日志
     *
     * @return
     */
    @Override
    public CommonResponse<Page<XxlJobLog>> pageLogList(int pageIndex,
                                                       int pageSize,
                                                       int jobGroup,
                                                       int jobId,
                                                       int logStatus,
                                                       String filterTime) {
        return CommonResponse.error("网络问题，分页查询调度任务日志失败。");
    }

    /**
     * 查询执行日志详情
     *
     * @param executorAddress 执行器地址
     * @param triggerTime     触发时间
     * @param logId           日志ID
     * @param fromLineNum     从行数
     * @return
     */
    @Override
    public CommonResponse<String> logDetailCat(String executorAddress, long triggerTime, int logId, int fromLineNum) {
        return CommonResponse.error("网络问题，查询执行日志详情失败。");
    }

    /**
     * 获取调度任务统计信息
     *
     * @return
     */
    @Override
    public CommonResponse<Map<String,Object>> dashboardInfo() {
        return CommonResponse.error("网络问题，获取调度任务统计信息失败。");
    }

    /**
     * 获取调度任务统计信息
     *
     * @param startDateStr
     * @param endDateStr
     * @return
     */
    @Override
    public CommonResponse<Map<String, Object>> pieAndBarInfo(String startDateStr, String endDateStr) {
        return CommonResponse.error("网络问题，获取调度任务统计信息失败。");
    }
}
