/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.trigger.XxlJobTrigger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTriggerPoolHelper {
    private static Logger logger = LoggerFactory.getLogger(JobTriggerPoolHelper.class);
    private ThreadPoolExecutor fastTriggerPool = new ThreadPoolExecutor(8, 200, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "xxl-job, admin JobTriggerPoolHelper-fastTriggerPool-" + r.hashCode());
        }
    });
    private ThreadPoolExecutor slowTriggerPool = new ThreadPoolExecutor(0, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "xxl-job, admin JobTriggerPoolHelper-slowTriggerPool-" + r.hashCode());
        }
    });
    private volatile long minTim = System.currentTimeMillis() / 60000L;
    private volatile Map<Integer, AtomicInteger> jobTimeoutCountMap = new ConcurrentHashMap<Integer, AtomicInteger>();
    private static JobTriggerPoolHelper helper = new JobTriggerPoolHelper();

    public void addTrigger(final int jobId, final TriggerTypeEnum triggerType, final int failRetryCount, final String executorShardingParam, final String executorParam) {
        ThreadPoolExecutor triggerPool_ = this.fastTriggerPool;
        AtomicInteger jobTimeoutCount = this.jobTimeoutCountMap.get(jobId);
        if (jobTimeoutCount != null && jobTimeoutCount.get() > 10) {
            triggerPool_ = this.slowTriggerPool;
        }
        triggerPool_.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    XxlJobTrigger.trigger(jobId, triggerType, failRetryCount, executorShardingParam, executorParam);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    AtomicInteger timeoutCount;
                    long cost;
                    long minTim_now = System.currentTimeMillis() / 60000L;
                    if (JobTriggerPoolHelper.this.minTim != minTim_now) {
                        JobTriggerPoolHelper.this.minTim = minTim_now;
                        JobTriggerPoolHelper.this.jobTimeoutCountMap.clear();
                    }
                    if ((cost = System.currentTimeMillis() - start) > 500L && (timeoutCount = JobTriggerPoolHelper.this.jobTimeoutCountMap.put(jobId, new AtomicInteger(1))) != null) {
                        timeoutCount.incrementAndGet();
                    }
                }
            }
        });
    }

    public void stop() {
        this.fastTriggerPool.shutdownNow();
        this.slowTriggerPool.shutdownNow();
        logger.info(">>>>>>>>> xxl-job trigger thread pool shutdown success.");
    }

    public static void trigger(int jobId, TriggerTypeEnum triggerType, int failRetryCount, String executorShardingParam, String executorParam) {
        helper.addTrigger(jobId, triggerType, failRetryCount, executorShardingParam, executorParam);
    }

    public static void toStop() {
        helper.stop();
    }
}

