/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.service.impl;

import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogDao;
import com.xxl.job.admin.dao.XxlJobRegistryDao;
import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.RegistryParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdminBizImpl
implements AdminBiz {
    private static Logger logger = LoggerFactory.getLogger(AdminBizImpl.class);
    @Resource
    public XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    private XxlJobRegistryDao xxlJobRegistryDao;

    public ReturnT<String> callback(List<HandleCallbackParam> callbackParamList) {
        for (HandleCallbackParam handleCallbackParam : callbackParamList) {
            ReturnT<String> callbackResult = this.callback(handleCallbackParam);
            logger.debug(">>>>>>>>> JobApiController.callback {}, handleCallbackParam={}, callbackResult={}", new Object[]{callbackResult.getCode() == IJobHandler.SUCCESS.getCode() ? "success" : "fail", handleCallbackParam, callbackResult});
        }
        return ReturnT.SUCCESS;
    }

    private ReturnT<String> callback(HandleCallbackParam handleCallbackParam) {
        XxlJobInfo xxlJobInfo;
        XxlJobLog log = this.xxlJobLogDao.load(handleCallbackParam.getLogId());
        if (log == null) {
            return new ReturnT(500, "log item not found.");
        }
        if (log.getHandleCode() > 0) {
            return new ReturnT(500, "log repeate callback.");
        }
        String callbackMsg = null;
        if (IJobHandler.SUCCESS.getCode() == handleCallbackParam.getExecuteResult().getCode() && (xxlJobInfo = this.xxlJobInfoDao.loadById(log.getJobId())) != null && xxlJobInfo.getChildJobId() != null && xxlJobInfo.getChildJobId().trim().length() > 0) {
            callbackMsg = "<br><br><span style=\"color:#00c0ef;\" > >>>>>>>>>>>" + I18nUtil.getString("jobconf_trigger_child_run") + "<<<<<<<<<<< </span><br>";
            String[] childJobIds = xxlJobInfo.getChildJobId().split(",");
            for (int i = 0; i < childJobIds.length; ++i) {
                int childJobId;
                int n = childJobId = childJobIds[i] != null && childJobIds[i].trim().length() > 0 && this.isNumeric(childJobIds[i]) ? Integer.valueOf(childJobIds[i]) : -1;
                if (childJobId > 0) {
                    JobTriggerPoolHelper.trigger(childJobId, TriggerTypeEnum.PARENT, -1, null, null);
                    ReturnT triggerChildResult = ReturnT.SUCCESS;
                    callbackMsg = callbackMsg + MessageFormat.format(I18nUtil.getString("jobconf_callback_child_msg1"), i + 1, childJobIds.length, childJobIds[i], triggerChildResult.getCode() == 200 ? I18nUtil.getString("system_success") : I18nUtil.getString("system_fail"), triggerChildResult.getMsg());
                    continue;
                }
                callbackMsg = callbackMsg + MessageFormat.format(I18nUtil.getString("jobconf_callback_child_msg2"), i + 1, childJobIds.length, childJobIds[i]);
            }
        }
        StringBuffer handleMsg = new StringBuffer();
        if (log.getHandleMsg() != null) {
            handleMsg.append(log.getHandleMsg()).append("<br>");
        }
        if (handleCallbackParam.getExecuteResult().getMsg() != null) {
            handleMsg.append(handleCallbackParam.getExecuteResult().getMsg());
        }
        if (callbackMsg != null) {
            handleMsg.append(callbackMsg);
        }
        log.setHandleTime(new Date());
        log.setHandleCode(handleCallbackParam.getExecuteResult().getCode());
        log.setHandleMsg(handleMsg.toString());
        this.xxlJobLogDao.updateHandleInfo(log);
        return ReturnT.SUCCESS;
    }

    private boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public ReturnT<String> registry(RegistryParam registryParam) {
        int ret = this.xxlJobRegistryDao.registryUpdate(registryParam.getRegistGroup(), registryParam.getRegistryKey(), registryParam.getRegistryValue());
        if (ret < 1) {
            this.xxlJobRegistryDao.registrySave(registryParam.getRegistGroup(), registryParam.getRegistryKey(), registryParam.getRegistryValue());
        }
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> registryRemove(RegistryParam registryParam) {
        this.xxlJobRegistryDao.registryDelete(registryParam.getRegistGroup(), registryParam.getRegistryKey(), registryParam.getRegistryValue());
        return ReturnT.SUCCESS;
    }
}

