package com.ejianc.business.labor.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;


/**
 * 信息反馈
 *
 * @author generator
 *
 */
@ApiModel("信息反馈")
public class InfoFeedbackVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("项目名称")
    private Long projectId;
    @ApiModelProperty("所属班组")
    private Long teamId;
    @ApiModelProperty("所属班组")
    private String teamName;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织d")
    private Long orgId;
    @ApiModelProperty("所属组织")
    private String orgName;
    @ApiModelProperty("反馈人")
    private Long employeeId;
    @ApiModelProperty("反馈人")
    private String employeeName;
    @ApiModelProperty("日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate;
    @ApiModelProperty("反馈内容")
    private String memo;


    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 所属班组
     */
    public Long getTeamId() {
        return teamId;
    }

    /**
     * 所属班组
     */
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    /**
     * 所属班组
     */
    public String getTeamName() {
        return teamName;
    }

    /**
     * 所属班组
     */
    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 所属组织d
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织d
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 所属组织
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 反馈人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 反馈人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 反馈内容
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 反馈内容
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

}
