package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 加班申请明细
 * 
 * @author generator
 * 
 */
@ApiModel("加班申请明细")
public class OvertimeApplyDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("父表id")
    private Long applyId; // 父表id
    @ApiModelProperty("工人id")
    private Long workerId;
    @ApiModelProperty("姓名")
    private String workerName;
    @ApiModelProperty("身份证")
    private String idCard;
    @ApiModelProperty("性別 1:男 2:女")
    private Integer sex;
    @ApiModelProperty("班组id")
    private String teamId;
    @ApiModelProperty("班组名称")
    private String teamName;
    @ApiModelProperty("工种id")
    private String workType;
    @ApiModelProperty("工种名称")
    private String workTypeName;
    @ApiModelProperty("加班天数")
    private BigDecimal overtimeHours;
    @ApiModelProperty("加班工资")
    private BigDecimal overtimeMny;
    @ApiModelProperty("备注")
    private String bodyMemo;
    @ApiModelProperty("来源 1：花名册 2：自制")
    private Integer source;
    private String overtimeMemo;//加班原因

    private Long projectId;
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date overtimeDate;

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getOvertimeDate() {
        return overtimeDate;
    }

    public void setOvertimeDate(Date overtimeDate) {
        this.overtimeDate = overtimeDate;
    }

    public String getOvertimeMemo() {
        return overtimeMemo;
    }

    public void setOvertimeMemo(String overtimeMemo) {
        this.overtimeMemo = overtimeMemo;
    }
    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    /**
     * 工人id
     */
    public Long getWorkerId() {
        return workerId;
    }

    /**
     * 工人id
     */
    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    /**
     * 姓名
     */
    public String getWorkerName() {
        return workerName;
    }

    /**
     * 姓名
     */
    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    /**
     * 身份证
     */
    public String getIdCard() {
        return idCard;
    }

    /**
     * 身份证
     */
    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    /**
     * 性別 1:男 2:女
     */
    public Integer getSex() {
        return sex;
    }

    /**
     * 性別 1:男 2:女
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }
    /**
     * 班组id
     */
    public String getTeamId() {
        return teamId;
    }

    /**
     * 班组id
     */
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
    /**
     * 班组名称
     */
    public String getTeamName() {
        return teamName;
    }

    /**
     * 班组名称
     */
    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    /**
     * 工种id
     */
    public String getWorkType() {
        return workType;
    }

    /**
     * 工种id
     */
    public void setWorkType(String workType) {
        this.workType = workType;
    }
    /**
     * 工种名称
     */
    public String getWorkTypeName() {
        return workTypeName;
    }

    /**
     * 工种名称
     */
    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    /**
     * 加班天数
     */
    public BigDecimal getOvertimeHours() {
        return overtimeHours;
    }

    /**
     * 加班天数
     */
    public void setOvertimeHours(BigDecimal overtimeHours) {
        this.overtimeHours = overtimeHours;
    }
    /**
     * 加班工资
     */
    public BigDecimal getOvertimeMny() {
        return overtimeMny;
    }

    /**
     * 加班工资
     */
    public void setOvertimeMny(BigDecimal overtimeMny) {
        this.overtimeMny = overtimeMny;
    }
    /**
     * 备注
     */
    public String getBodyMemo() {
        return bodyMemo;
    }

    /**
     * 备注
     */
    public void setBodyMemo(String bodyMemo) {
        this.bodyMemo = bodyMemo;
    }
    /**
     * 来源 1：花名册 2：自制
     */
    public Integer getSource() {
        return source;
    }

    /**
     * 来源 1：花名册 2：自制
     */
    public void setSource(Integer source) {
        this.source = source;
    }
    
}
