package com.ejianc.business.labor.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 劳务进场单-变更记录
 *
 * @author baipengyan
 */
public class WorkerEnterRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private String name; // 姓名
    private String idCard; // 身份证号
    private Integer sex; // 1-男，2-女
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    private Integer userAge; // 年龄
    private String nation; // 民族
    private String phone; // 手机号
    private String teamId; // 劳务班组
    private String teamName; // 劳务班组名称
    private String workType; // 工种
    private String workTypeName; // 工种名称
    private String bankName; // 开户行
    private String bankAccount; // 银行账号
    private Integer wagesType; // 工资类型
    private String wagesTypeName; // 工资类型名称
    private BigDecimal wage; // 工价
    private String province; // 省
    private String city; // 市
    private String area; // 省市
    private String address; // 详细地址
    private Integer sourceFlag; // 来源：1-自制 项目班组 2、公司花名册 3、邀请
    private String sourceFlagName; // 来源名称
    private Integer idCardPhotoFlag; // 身份证照片状态：0-待校验，1-是，2-否，3-异常
    private Integer facePhotoFlag; // 人脸采集状态：0-待校验，1-是，2-否，3-异常
    private Integer workState; // 用工状态：0未入场，1已入场
    private Integer enabled; // 1:启用/0:停用
    private Long projectId; // 所属项目
    private String projectName; // 所属项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织
    private Long parentOrgId; // 组织id
    private String parentOrgName; // 项目部所属组织
    private Long subContractId; // 分包合同id
    private String subContractName; // 分包合同
    private Long supplierId; // 供应商ID
    private String supplierName; // 供应商
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 进场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 退场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date manageDate; // 办理日期
    private String memo; // 备注
    private String idCardName; // 身份证照片识别的姓名
    private String idCardNo; // 身份证照片识别的身份证号
    private String idCardSex; // 身份证照片识别的性别，1-男，2-女
    private String idCardBirthDate; // 身份证照片识别的出生年月
    private String idCardNation; // 身份证照片识别的民族
    private String idCardStartDate; // 身份证照片识别的起始有效期
    private String idCardEndDate; // 身份证照片识别的截止有效期
    private String idCardIssue; // 身份证照片识别的签发机关
    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    private Integer idCardFrontPhotoFlag; // 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardFrontPhotoExceptional; // 身份证正面异常信息
    private Integer idCardBackPhotoFlag; // 身份证反面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardBackPhotoExceptional; // 身份证反面异常信息
    private String facePhotoExceptional; // 人脸采集异常信息


    // 变更字段
    private Integer changeState; // 变更状态

    private Long curChangingId; // 当前对应的变更Id

    private Integer changeVersion; // 变更版本

    private Long workerEnterId; // 劳务进场单Id

    private String changeReason; // 变更原因

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    private BigDecimal overtimeWage; // 加班工价
    private String emergencyContact; // 紧急联系人
    private Integer buyFlag; // 是否代买保险

    private Long workCategory; // 工类
    private String workCategoryName; // 工类名称
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getWorkCategory() {
        return workCategory;
    }
    @ReferDeserialTransfer
    public void setWorkCategory(Long workCategory) {
        this.workCategory = workCategory;
    }

    public String getWorkCategoryName() {
        return workCategoryName;
    }

    public void setWorkCategoryName(String workCategoryName) {
        this.workCategoryName = workCategoryName;
    }



    public String getEmergencyContact() {
        return emergencyContact;
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact;
    }

    public Integer getBuyFlag() {
        return buyFlag;
    }

    public void setBuyFlag(Integer buyFlag) {
        this.buyFlag = buyFlag;
    }
    public BigDecimal getOvertimeWage() {
        return overtimeWage;
    }

    public void setOvertimeWage(BigDecimal overtimeWage) {
        this.overtimeWage = overtimeWage;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Integer getUserAge() {
        return userAge;
    }

    public void setUserAge(Integer userAge) {
        this.userAge = userAge;
    }

    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @ReferSerialTransfer(referCode = "projectTeamRef")
    public String getTeamId() {
        return teamId;
    }

    @ReferDeserialTransfer
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getWorkType() {
        return workType;
    }

    @ReferDeserialTransfer
    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Integer getWagesType() {
        return wagesType;
    }

    public void setWagesType(Integer wagesType) {
        this.wagesType = wagesType;
    }

    public String getWagesTypeName() {
        return wagesTypeName;
    }

    public void setWagesTypeName(String wagesTypeName) {
        this.wagesTypeName = wagesTypeName;
    }

    public BigDecimal getWage() {
        return wage;
    }

    public void setWage(BigDecimal wage) {
        this.wage = wage;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }

    public String getSourceFlagName() {
        return sourceFlagName;
    }

    public void setSourceFlagName(String sourceFlagName) {
        this.sourceFlagName = sourceFlagName;
    }

    public Integer getIdCardPhotoFlag() {
        return idCardPhotoFlag;
    }

    public void setIdCardPhotoFlag(Integer idCardPhotoFlag) {
        this.idCardPhotoFlag = idCardPhotoFlag;
    }

    public Integer getFacePhotoFlag() {
        return facePhotoFlag;
    }

    public void setFacePhotoFlag(Integer facePhotoFlag) {
        this.facePhotoFlag = facePhotoFlag;
    }

    public Integer getWorkState() {
        return workState;
    }

    public void setWorkState(Integer workState) {
        this.workState = workState;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "sub-contract-register")
    public Long getSubContractId() {
        return subContractId;
    }

    @ReferDeserialTransfer
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }

    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }

    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }

    public Date getManageDate() {
        return manageDate;
    }

    public void setManageDate(Date manageDate) {
        this.manageDate = manageDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getIdCardName() {
        return idCardName;
    }

    public void setIdCardName(String idCardName) {
        this.idCardName = idCardName;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getIdCardSex() {
        return idCardSex;
    }

    public void setIdCardSex(String idCardSex) {
        this.idCardSex = idCardSex;
    }

    public String getIdCardBirthDate() {
        return idCardBirthDate;
    }

    public void setIdCardBirthDate(String idCardBirthDate) {
        this.idCardBirthDate = idCardBirthDate;
    }

    public String getIdCardNation() {
        return idCardNation;
    }

    public void setIdCardNation(String idCardNation) {
        this.idCardNation = idCardNation;
    }

    public String getIdCardStartDate() {
        return idCardStartDate;
    }

    public void setIdCardStartDate(String idCardStartDate) {
        this.idCardStartDate = idCardStartDate;
    }

    public String getIdCardEndDate() {
        return idCardEndDate;
    }

    public void setIdCardEndDate(String idCardEndDate) {
        this.idCardEndDate = idCardEndDate;
    }

    public String getIdCardIssue() {
        return idCardIssue;
    }

    public void setIdCardIssue(String idCardIssue) {
        this.idCardIssue = idCardIssue;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getIdCardFrontPhotoFlag() {
        return idCardFrontPhotoFlag;
    }

    public void setIdCardFrontPhotoFlag(Integer idCardFrontPhotoFlag) {
        this.idCardFrontPhotoFlag = idCardFrontPhotoFlag;
    }

    public String getIdCardFrontPhotoExceptional() {
        return idCardFrontPhotoExceptional;
    }

    public void setIdCardFrontPhotoExceptional(String idCardFrontPhotoExceptional) {
        this.idCardFrontPhotoExceptional = idCardFrontPhotoExceptional;
    }

    public Integer getIdCardBackPhotoFlag() {
        return idCardBackPhotoFlag;
    }

    public void setIdCardBackPhotoFlag(Integer idCardBackPhotoFlag) {
        this.idCardBackPhotoFlag = idCardBackPhotoFlag;
    }

    public String getIdCardBackPhotoExceptional() {
        return idCardBackPhotoExceptional;
    }

    public void setIdCardBackPhotoExceptional(String idCardBackPhotoExceptional) {
        this.idCardBackPhotoExceptional = idCardBackPhotoExceptional;
    }

    public String getFacePhotoExceptional() {
        return facePhotoExceptional;
    }

    public void setFacePhotoExceptional(String facePhotoExceptional) {
        this.facePhotoExceptional = facePhotoExceptional;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Long getCurChangingId() {
        return curChangingId;
    }

    public void setCurChangingId(Long curChangingId) {
        this.curChangingId = curChangingId;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getWorkerEnterId() {
        return workerEnterId;
    }

    public void setWorkerEnterId(Long workerEnterId) {
        this.workerEnterId = workerEnterId;
    }
}
