package com.ejianc.business.labor.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 考勤记录
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public class AttendanceVO extends BaseVO {
	private static final long serialVersionUID = 1485878105109969877L;

	private Long workerId; // 劳务员工id
	private Long projectTeamId; // 项目班组
	private String projectTeamName; // 项目班组名称
	private String projectTeamInnerCode; // 项目班组innerCode
	private String orgTeamId; // 公司班组
	private String orgTeamName; // 公司班组名称
	private String orgTeamInnerCode; // 公司班组innerCode
	private String name; // 姓名
	private String idCard; // 身份证号
	private String phone; // 手机号
	private String teamId; // 劳务班组
	private String teamName; // 劳务班组名称
	private Long projectWorkType; // 项目工种
	private String projectWorkTypeName; // 项目工种名称
	private String orgWorkType; // 公司工种
	private String orgWorkTypeName; // 公司工种名称
	private Long orgId; // 组织id
	private String orgName; // 组织名称
	private Long parentOrgId; // 项目部所属组织id
	private String parentOrgName; // 项目部所属组织名称
	@JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date punchCardDate; // 打卡日期
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date startWorkTime; // 上班时间
	private String startWorkPlace; // 上班打卡地点
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date endWorkTime; // 下班时间
	private String endWorkPlace; // 下班打卡地点
	private String duration; // 时长
	private String attendanceStatus; // 考勤状态
	private Integer remoteFlag; // 是否是异地打卡（0：否，1:是 ）
	private Long projectId; // 项目id
	private String projectName; // 项目名称
	private String projectAddress; // 项目地址
	private Integer attendanceDays; // 本期间出勤天数
	private Integer attendanceHours; // 本期间出勤时长/小时
	private Integer attendanceErrors; // 考勤异常次数
	private String remoteFlagName; // 是否是异地打卡（0：否，1:是 ）


	public Long getWorkerId() {
		return workerId;
	}

	public void setWorkerId(Long workerId) {
		this.workerId = workerId;
	}

	public Long getProjectTeamId() {
		return projectTeamId;
	}

	public void setProjectTeamId(Long projectTeamId) {
		this.projectTeamId = projectTeamId;
	}

	public String getProjectTeamName() {
		return projectTeamName;
	}

	public void setProjectTeamName(String projectTeamName) {
		this.projectTeamName = projectTeamName;
	}

	public String getProjectTeamInnerCode() {
		return projectTeamInnerCode;
	}

	public void setProjectTeamInnerCode(String projectTeamInnerCode) {
		this.projectTeamInnerCode = projectTeamInnerCode;
	}

	public String getOrgTeamId() {
		return orgTeamId;
	}

	public void setOrgTeamId(String orgTeamId) {
		this.orgTeamId = orgTeamId;
	}

	public String getOrgTeamName() {
		return orgTeamName;
	}

	public void setOrgTeamName(String orgTeamName) {
		this.orgTeamName = orgTeamName;
	}

	public String getOrgTeamInnerCode() {
		return orgTeamInnerCode;
	}

	public void setOrgTeamInnerCode(String orgTeamInnerCode) {
		this.orgTeamInnerCode = orgTeamInnerCode;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getIdCard() {
		return idCard;
	}

	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getTeamId() {
		return teamId;
	}

	public void setTeamId(String teamId) {
		this.teamId = teamId;
	}

	public String getTeamName() {
		return teamName;
	}

	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}

	public Long getProjectWorkType() {
		return projectWorkType;
	}

	public void setProjectWorkType(Long projectWorkType) {
		this.projectWorkType = projectWorkType;
	}

	public String getProjectWorkTypeName() {
		return projectWorkTypeName;
	}

	public void setProjectWorkTypeName(String projectWorkTypeName) {
		this.projectWorkTypeName = projectWorkTypeName;
	}

	public String getOrgWorkType() {
		return orgWorkType;
	}

	public void setOrgWorkType(String orgWorkType) {
		this.orgWorkType = orgWorkType;
	}

	public String getOrgWorkTypeName() {
		return orgWorkTypeName;
	}

	public void setOrgWorkTypeName(String orgWorkTypeName) {
		this.orgWorkTypeName = orgWorkTypeName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Date getPunchCardDate() {
		return punchCardDate;
	}

	public void setPunchCardDate(Date punchCardDate) {
		this.punchCardDate = punchCardDate;
	}

	public Date getStartWorkTime() {
		return startWorkTime;
	}

	public void setStartWorkTime(Date startWorkTime) {
		this.startWorkTime = startWorkTime;
	}

	public String getStartWorkPlace() {
		return startWorkPlace;
	}

	public void setStartWorkPlace(String startWorkPlace) {
		this.startWorkPlace = startWorkPlace;
	}

	public Date getEndWorkTime() {
		return endWorkTime;
	}

	public void setEndWorkTime(Date endWorkTime) {
		this.endWorkTime = endWorkTime;
	}

	public String getEndWorkPlace() {
		return endWorkPlace;
	}

	public void setEndWorkPlace(String endWorkPlace) {
		this.endWorkPlace = endWorkPlace;
	}

	public String getDuration() {
		return duration;
	}

	public void setDuration(String duration) {
		this.duration = duration;
	}

	public String getAttendanceStatus() {
		return attendanceStatus;
	}

	public void setAttendanceStatus(String attendanceStatus) {
		this.attendanceStatus = attendanceStatus;
	}

	public Integer getRemoteFlag() {
		return remoteFlag;
	}

	public void setRemoteFlag(Integer remoteFlag) {
		this.remoteFlag = remoteFlag;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getProjectAddress() {
		return projectAddress;
	}

	public void setProjectAddress(String projectAddress) {
		this.projectAddress = projectAddress;
	}

	public Integer getAttendanceDays() {
		return attendanceDays;
	}

	public void setAttendanceDays(Integer attendanceDays) {
		this.attendanceDays = attendanceDays;
	}

	public Integer getAttendanceHours() {
		return attendanceHours;
	}

	public void setAttendanceHours(Integer attendanceHours) {
		this.attendanceHours = attendanceHours;
	}

	public Integer getAttendanceErrors() {
		return attendanceErrors;
	}

	public void setAttendanceErrors(Integer attendanceErrors) {
		this.attendanceErrors = attendanceErrors;
	}

	public String getRemoteFlagName() {
		return remoteFlagName;
	}

	public void setRemoteFlagName(String remoteFlagName) {
		this.remoteFlagName = remoteFlagName;
	}
}
