package com.ejianc.business.labor.utils;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 收入类型下拉枚举
 * @author songlx
 * @date: 2021/8/31
 */
public enum WagesTypeEnum {


    HOUR(1, "按小时计算"),
    DAY(2, "按日计算"),
    MONTH(3, "按月计算"),
    QUANT(4, "按工程量计算");

    private final Integer code;
    private final String name;
    private static Map<Integer, WagesTypeEnum> enumMap = new HashMap();

    private WagesTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getNameByCode(Long code) {
        WagesTypeEnum wagesTypeEnum = enumMap.get(code);
        return wagesTypeEnum != null ? wagesTypeEnum.getName() : null;
    }

    static {
        enumMap = (Map) EnumSet.allOf(WagesTypeEnum.class).stream().collect(Collectors.toMap(WagesTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
