package com.ejianc.business.labor.vo;

import java.util.List;

public class FilterOrgIdVo {

    /**
     * 当前组织
     */
    private Long orgId;
    /**
     * all-全部、
     * 2023-2023年、
     * 2021-2021年、
     * 2020-2020年、
     * 2019-2019年
     * near4Year-近四年；
     * 默认今年
     */
    private String dateIn;
    /**
     * all-全部、
     * 1-未开工,
     * 2-在建，
     * 3-完成
     * 默认在建；
     */
    private String projectStatus;

    private String searchText;

    private List<String> searchFields;

    public List<String> getSearchFields() {
        return searchFields;
    }

    public void setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
    }

    public String getSearchText() {
        return searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public static FilterOrgIdVo getInstance(Long orgId, String dateIn, String projectStatus) {
        return new FilterOrgIdVo(orgId, dateIn, projectStatus);
    }

    public FilterOrgIdVo() {
    }

    public FilterOrgIdVo(Long orgId, String dateIn, String projectStatus) {
        this.orgId = orgId;
        this.dateIn = dateIn;
        this.projectStatus = projectStatus;
    }

    public FilterOrgIdVo(Long orgId, String dateIn, String projectStatus, String searchText, List<String> searchFields) {
        this.orgId = orgId;
        this.dateIn = dateIn;
        this.projectStatus = projectStatus;
        this.searchText = searchText;
        this.searchFields = searchFields;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getDateIn() {
        return dateIn;
    }

    public void setDateIn(String dateIn) {
        this.dateIn = dateIn;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
}
