package com.ejianc.business.labor.vo;

import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 用工记录
 * 
 * @author generator
 * 
 */
public class WorkRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long workerId; // 劳务员工id
    private String projectTeamId; // 项目班组
    private String projectTeamName; // 项目班组名称
    private String projectTeamInnerCode; // 项目班组innerCode
    private String orgTeamId; // 公司班组
    private String orgTeamName; // 公司班组名称
    private String orgTeamInnerCode; // 公司班组innerCode
    private String TeamInnerCode;// 班组innerCode
    private String name; // 姓名
    private String idCard; // 身份证号
    private Integer sex; // 1-男，2-女
    private String sexName; // 1-男，2-女

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    private String nation; // 民族
    private String phone; // 手机号
    private String teamId; // 劳务班组
    private String teamName; // 劳务班组名称
    private String bankName; // 开户行
    private String bankAccount; // 银行账号
    private Integer wagesType; // 工资类型
    private String wagesTypeName; // 工资类型名称
    private BigDecimal wage; // 工价
    private String province; // 省
    private String city; // 市
    private String area; // 省市
    private String address; // 详细地址
    private Long lastProjectId; // 最后更新的项目id
    private String projectWorkType; // 项目工种
    private String projectWorkTypeName; // 项目工种名称
    private String orgWorkType; // 公司工种
    private String orgWorkTypeName; // 公司工种名称
    private String workType; // 工种
    private String workTypeName; // 工种名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgName; // 项目部所属组织
    private String projectAddress; // 项目地址
    private Integer lastFlag; // 最新记录标志（1是0否）
    private Integer sourceFlag; // 来源（1自制-劳务进场单、2公司花名册、3邀请）
    private String sourceFlagName; // 来源（1自制-劳务进场单、2公司花名册、3邀请）

    private Long sourceId; // 来源主键（劳务进场单id）
    private Integer enterExitState; // 在场状态（1在场、0退场）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 进场日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 退场日期
    private Long subContractId; // 分包合同id
    private String subContractName; // 分包合同
    private Long supplierId; // 供应商ID
    private String supplierName; // 供应商
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String idCardName; // 身份证照片识别的姓名
    private String idCardNo; // 身份证照片识别的身份证号
    private String idCardSex; // 身份证照片识别的性别，1-男，2-女
    private String idCardBirthDate; // 身份证照片识别的出生年月
    private String idCardNation; // 身份证照片识别的民族
    private String idCardStartDate; // 身份证照片识别的起始有效期
    private String idCardEndDate; // 身份证照片识别的截止有效期
    private String idCardIssue; // 身份证照片识别的签发机关
    private Integer idCardFrontPhotoFlag; // 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardFrontPhotoExceptional; // 身份证正面异常信息
    private Integer idCardBackPhotoFlag; // 身份证反面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardBackPhotoExceptional; // 身份证反面异常信息
    private Integer facePhotoFlag; // 人脸采集状态：0-待校验，1-是，2-否，3-异常
    private String facePhotoExceptional; // 人脸采集异常信息
    private Integer billState;
    private List<Long> ids = new ArrayList<>(); //批量修改使用的多个人员id
    private List<WorkRecordVO> recordList = new ArrayList<>(); //用工记录
    private BigDecimal checkingDay;//考勤天数目前等于 进场时间至退场时间（包含）之间的天数；
    private Integer checkingDayFlag;//考勤天数是否大于0 1是,0否


    //用工合同附件id
    private Long subContractFileId;
    private List<AttachmentVO>  subContractFileList = new ArrayList<>();
    private String subContractFileName;
    private String enterExitStateName; // 在场状态（1在场、0退场）
    private String idCardBackPhotoFlagName; // 身份证反面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardFrontPhotoFlagName; // 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
    private String facePhotoFlagName; // 人脸采集状态：0-待校验，1-是，2-否，3-异常

    private String icon; // 头像

    private BigDecimal overtimeWage; // 加班工价

    public BigDecimal getOvertimeWage() {
        return overtimeWage;
    }

    public void setOvertimeWage(BigDecimal overtimeWage) {
        this.overtimeWage = overtimeWage;
    }


    public List<AttachmentVO> getSubContractFileList() {
        return subContractFileList;
    }

    public void setSubContractFileList(List<AttachmentVO> subContractFileList) {
        this.subContractFileList = subContractFileList;
    }

    public Integer getCheckingDayFlag() {
        return checkingDayFlag;
    }

    public void setCheckingDayFlag(Integer checkingDayFlag) {
        this.checkingDayFlag = checkingDayFlag;
    }

    public String getIdCardFrontPhotoFlagName() {
        return idCardFrontPhotoFlagName;
    }

    public void setIdCardFrontPhotoFlagName(String idCardFrontPhotoFlagName) {
        this.idCardFrontPhotoFlagName = idCardFrontPhotoFlagName;
    }

    public String getFacePhotoFlagName() {
        return facePhotoFlagName;
    }

    public void setFacePhotoFlagName(String facePhotoFlagName) {
        this.facePhotoFlagName = facePhotoFlagName;
    }

    public String getIdCardBackPhotoFlagName() {
        return idCardBackPhotoFlagName;
    }

    public void setIdCardBackPhotoFlagName(String idCardBackPhotoFlagName) {
        this.idCardBackPhotoFlagName = idCardBackPhotoFlagName;
    }

    public String getEnterExitStateName() {
        return enterExitStateName;
    }

    public void setEnterExitStateName(String enterExitStateName) {
        this.enterExitStateName = enterExitStateName;
    }

    public String getSexName() {
        return sexName;
    }

    public void setSexName(String sexName) {
        this.sexName = sexName;
    }

    public Long getSubContractFileId() {
        return subContractFileId;
    }

    public void setSubContractFileId(Long subContractFileId) {
        this.subContractFileId = subContractFileId;
    }

    public String getSubContractFileName() {
        return subContractFileName;
    }

    public void setSubContractFileName(String subContractFileName) {
        this.subContractFileName = subContractFileName;
    }

    public BigDecimal getCheckingDay() {
        return checkingDay;
    }

    public void setCheckingDay(BigDecimal checkingDay) {
        this.checkingDay = checkingDay;
    }

    public List<WorkRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<WorkRecordVO> recordList) {
        this.recordList = recordList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getSourceFlagName() {
        return sourceFlagName;
    }

    public void setSourceFlagName(String sourceFlagName) {
        this.sourceFlagName = sourceFlagName;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public String getIdCardName() {
        return idCardName;
    }

    public void setIdCardName(String idCardName) {
        this.idCardName = idCardName;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getIdCardSex() {
        return idCardSex;
    }

    public void setIdCardSex(String idCardSex) {
        this.idCardSex = idCardSex;
    }

    public String getIdCardBirthDate() {
        return idCardBirthDate;
    }

    public void setIdCardBirthDate(String idCardBirthDate) {
        this.idCardBirthDate = idCardBirthDate;
    }

    public String getIdCardNation() {
        return idCardNation;
    }

    public void setIdCardNation(String idCardNation) {
        this.idCardNation = idCardNation;
    }

    public String getIdCardStartDate() {
        return idCardStartDate;
    }

    public void setIdCardStartDate(String idCardStartDate) {
        this.idCardStartDate = idCardStartDate;
    }

    public String getIdCardEndDate() {
        return idCardEndDate;
    }

    public void setIdCardEndDate(String idCardEndDate) {
        this.idCardEndDate = idCardEndDate;
    }

    public String getIdCardIssue() {
        return idCardIssue;
    }

    public void setIdCardIssue(String idCardIssue) {
        this.idCardIssue = idCardIssue;
    }

    public Integer getIdCardFrontPhotoFlag() {
        return idCardFrontPhotoFlag;
    }

    public void setIdCardFrontPhotoFlag(Integer idCardFrontPhotoFlag) {
        this.idCardFrontPhotoFlag = idCardFrontPhotoFlag;
    }

    public String getIdCardFrontPhotoExceptional() {
        return idCardFrontPhotoExceptional;
    }

    public void setIdCardFrontPhotoExceptional(String idCardFrontPhotoExceptional) {
        this.idCardFrontPhotoExceptional = idCardFrontPhotoExceptional;
    }

    public Integer getIdCardBackPhotoFlag() {
        return idCardBackPhotoFlag;
    }

    public void setIdCardBackPhotoFlag(Integer idCardBackPhotoFlag) {
        this.idCardBackPhotoFlag = idCardBackPhotoFlag;
    }

    public String getIdCardBackPhotoExceptional() {
        return idCardBackPhotoExceptional;
    }

    public void setIdCardBackPhotoExceptional(String idCardBackPhotoExceptional) {
        this.idCardBackPhotoExceptional = idCardBackPhotoExceptional;
    }

    public Integer getFacePhotoFlag() {
        return facePhotoFlag;
    }

    public void setFacePhotoFlag(Integer facePhotoFlag) {
        this.facePhotoFlag = facePhotoFlag;
    }

    public String getFacePhotoExceptional() {
        return facePhotoExceptional;
    }

    public void setFacePhotoExceptional(String facePhotoExceptional) {
        this.facePhotoExceptional = facePhotoExceptional;
    }

    public String getTeamInnerCode() {
        return TeamInnerCode;
    }

    public void setTeamInnerCode(String teamInnerCode) {
        TeamInnerCode = teamInnerCode;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getWorkType() {
        return workType;
    }
    @ReferDeserialTransfer
    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
//    @ReferSerialTransfer(referCode = "projectTeamRef")
    public String getProjectTeamId() {
        return projectTeamId;
    }
//    @ReferDeserialTransfer
    public void setProjectTeamId(String projectTeamId) {
        this.projectTeamId = projectTeamId;
    }
    public String getProjectTeamName() {
        return projectTeamName;
    }

    public void setProjectTeamName(String projectTeamName) {
        this.projectTeamName = projectTeamName;
    }
    public String getProjectTeamInnerCode() {
        return projectTeamInnerCode;
    }

    public void setProjectTeamInnerCode(String projectTeamInnerCode) {
        this.projectTeamInnerCode = projectTeamInnerCode;
    }
//    @ReferSerialTransfer(referCode = "orgTeamRef")
    public String getOrgTeamId() {
        return orgTeamId;
    }
//    @ReferDeserialTransfer
    public void setOrgTeamId(String orgTeamId) {
        this.orgTeamId = orgTeamId;
    }
    public String getOrgTeamName() {
        return orgTeamName;
    }

    public void setOrgTeamName(String orgTeamName) {
        this.orgTeamName = orgTeamName;
    }
    public String getOrgTeamInnerCode() {
        return orgTeamInnerCode;
    }

    public void setOrgTeamInnerCode(String orgTeamInnerCode) {
        this.orgTeamInnerCode = orgTeamInnerCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    @ReferSerialTransfer(referCode = "projectTeamRef")
    public String getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(String teamId) {
        this.teamId = StringUtils.isBlank(teamId) ? null : teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public Integer getWagesType() {
        return wagesType;
    }

    public void setWagesType(Integer wagesType) {
        this.wagesType = wagesType;
    }
    public String getWagesTypeName() {
        return wagesTypeName;
    }

    public void setWagesTypeName(String wagesTypeName) {
        this.wagesTypeName = wagesTypeName;
    }
    public BigDecimal getWage() {
        return wage;
    }

    public void setWage(BigDecimal wage) {
        this.wage = wage;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Long getLastProjectId() {
        return lastProjectId;
    }

    public void setLastProjectId(Long lastProjectId) {
        this.lastProjectId = lastProjectId;
    }
    public String getProjectWorkType() {
        return projectWorkType;
    }

    public void setProjectWorkType(String projectWorkType) {
        this.projectWorkType = projectWorkType;
    }
    public String getProjectWorkTypeName() {
        return projectWorkTypeName;
    }

    public void setProjectWorkTypeName(String projectWorkTypeName) {
        this.projectWorkTypeName = projectWorkTypeName;
    }
    public String getOrgWorkType() {
        return orgWorkType;
    }

    public void setOrgWorkType(String orgWorkType) {
        this.orgWorkType = orgWorkType;
    }
    public String getOrgWorkTypeName() {
        return orgWorkTypeName;
    }

    public void setOrgWorkTypeName(String orgWorkTypeName) {
        this.orgWorkTypeName = orgWorkTypeName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public Integer getLastFlag() {
        return lastFlag;
    }

    public void setLastFlag(Integer lastFlag) {
        this.lastFlag = lastFlag;
    }
    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getEnterExitState() {
        return enterExitState;
    }

    public void setEnterExitState(Integer enterExitState) {
        this.enterExitState = enterExitState;
    }
    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }
    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }
    @ReferSerialTransfer(referCode = "sub-contract-register")
    public Long getSubContractId() {
        return subContractId;
    }
    @ReferDeserialTransfer
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}
