package com.ejianc.business.labor.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 公司花名册人员
 *
 * @author generator
 */
public class WorkerVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 姓名
    private String code; // 编码
    private String idCard; // 身份证号
    private Integer sex; // 1-男，2-女
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    private String nation; // 民族
    private String phone; // 手机号
    private String teamId; // 劳务班组
    private String teamName; // 劳务班组名称
    private String workType; // 工种
    private String workTypeName; // 工种名称
    private String bankName; // 开户行
    private String bankAccount; // 银行账号
    private Integer wagesType; // 工资类型
    private String wagesTypeName; // 工资类型名称
    private BigDecimal wage; // 工价
    private String province; // 省
    private String city; // 市
    private String area; // 省市
    private String address; // 详细地址
    private Integer sourceFlag; // 来源：1-公司自制，2-项目进场
    private String sourceFlagName; // 来源名称（固定显示的公司自制或第一个项目名称）
    private Long sourceProjectId; // 来源项目id
    private Long lastProjectId; // 最后更新的项目id
    private Integer idCardFrontPhotoFlag; // 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardFrontPhotoExceptional; // 身份证正面异常信息
    private Integer idCardBackPhotoFlag; // 身份证反面照片状态：0-待校验，1-是，2-否，3-异常
    private String idCardBackPhotoExceptional; // 身份证反面异常信息
    private Integer facePhotoFlag; // 人脸采集状态：0-待校验，1-是，2-否，3-异常
    private String facePhotoExceptional; // 人脸采集异常信息
    private Integer workState; // 用工状态：0未入场，1已入场
    private Integer enabled; // 1:启用/0:停用
    private String memo; // 备注
    private String idCardName; // 身份证照片识别的姓名
    private String idCardNo; // 身份证照片识别的身份证号
    private String idCardSex; // 身份证照片识别的性别，1-男，2-女
    private String idCardBirthDate; // 身份证照片识别的出生年月
    private String idCardNation; // 身份证照片识别的民族
    private String idCardStartDate; // 身份证照片识别的起始有效期
    private String idCardEndDate; // 身份证照片识别的截止有效期
    private String idCardIssue; // 身份证照片识别的签发机关

    private List<Long> ids = new ArrayList<>(); //批量修改使用的多个人员id

    private String sexName;
    /**
     * 导入失败原因
     */
    private String errorMessage;

    /**
     * 身份证状态信息，导出用
     */
    private String idCardFrontPhotoFlagName;

    /**
     * 人脸采集信息信息，导出用
     */
    private String facePhotoFlagName;

    /**
     * 用工状态信息，导出用
     */
    private String workStateName;


    /**
     * 启用状态信息，导出用
     */
    private String enabledName;
    private Long ruteProjectId; //记录项目id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 进场日期
    private Long subContractId; // 分包合同id
    private String subContractName; // 分包合同
    private Long supplierId; // 供应商ID
    private String supplierName; // 供应商

    private BigDecimal overtimeWage; // 加班工价

    public BigDecimal getOvertimeWage() {
        return overtimeWage;
    }

    public void setOvertimeWage(BigDecimal overtimeWage) {
        this.overtimeWage = overtimeWage;
    }

    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }
    @ReferDeserialTransfer
    public Long getSubContractId() {
        return subContractId;
    }

    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }

    public String getSubContractName() {
        return subContractName;
    }

    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getRuteProjectId() {
        return ruteProjectId;
    }

    public void setRuteProjectId(Long ruteProjectId) {
        this.ruteProjectId = ruteProjectId;
    }

    /**
     * 用工记录
     */
    private List<WorkRecordVO> workRecordList;

    public List<WorkRecordVO> getWorkRecordList() {
        return workRecordList;
    }

    public void setWorkRecordList(List<WorkRecordVO> workRecordList) {
        this.workRecordList = workRecordList;
    }

    public String getEnabledName() {
        return enabledName;
    }

    public void setEnabledName(String enabledName) {
        this.enabledName = enabledName;
    }

    public String getWorkStateName() {
        return workStateName;
    }

    public void setWorkStateName(String workStateName) {
        this.workStateName = workStateName;
    }

    public String getFacePhotoFlagName() {
        return facePhotoFlagName;
    }

    public void setFacePhotoFlagName(String facePhotoFlagName) {
        this.facePhotoFlagName = facePhotoFlagName;
    }

    public String getSexName() {
        return sexName;
    }

    public String getIdCardFrontPhotoFlagName() {
        return idCardFrontPhotoFlagName;
    }

    public void setIdCardFrontPhotoFlagName(String idCardFrontPhotoFlagName) {
        this.idCardFrontPhotoFlagName = idCardFrontPhotoFlagName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    @ReferSerialTransfer(referCode = "orgTeamRef")
    public String getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getWorkType() {
        return workType;
    }
    @ReferDeserialTransfer
    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public Integer getWagesType() {
        return wagesType;
    }

    public void setWagesType(Integer wagesType) {
        this.wagesType = wagesType;
    }
    public String getWagesTypeName() {
        return wagesTypeName;
    }

    public void setWagesTypeName(String wagesTypeName) {
        this.wagesTypeName = wagesTypeName;
    }
    public BigDecimal getWage() {
        return wage;
    }

    public void setWage(BigDecimal wage) {
        this.wage = wage;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public String getSourceFlagName() {
        return sourceFlagName;
    }

    public void setSourceFlagName(String sourceFlagName) {
        this.sourceFlagName = sourceFlagName;
    }
    public Long getSourceProjectId() {
        return sourceProjectId;
    }

    public void setSourceProjectId(Long sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    public Long getLastProjectId() {
        return lastProjectId;
    }

    public void setLastProjectId(Long lastProjectId) {
        this.lastProjectId = lastProjectId;
    }
    public Integer getIdCardFrontPhotoFlag() {
        return idCardFrontPhotoFlag;
    }

    public void setIdCardFrontPhotoFlag(Integer idCardFrontPhotoFlag) {
        this.idCardFrontPhotoFlag = idCardFrontPhotoFlag;
    }
    public String getIdCardFrontPhotoExceptional() {
        return idCardFrontPhotoExceptional;
    }

    public void setIdCardFrontPhotoExceptional(String idCardFrontPhotoExceptional) {
        this.idCardFrontPhotoExceptional = idCardFrontPhotoExceptional;
    }
    public Integer getIdCardBackPhotoFlag() {
        return idCardBackPhotoFlag;
    }

    public void setIdCardBackPhotoFlag(Integer idCardBackPhotoFlag) {
        this.idCardBackPhotoFlag = idCardBackPhotoFlag;
    }
    public String getIdCardBackPhotoExceptional() {
        return idCardBackPhotoExceptional;
    }

    public void setIdCardBackPhotoExceptional(String idCardBackPhotoExceptional) {
        this.idCardBackPhotoExceptional = idCardBackPhotoExceptional;
    }
    public Integer getFacePhotoFlag() {
        return facePhotoFlag;
    }

    public void setFacePhotoFlag(Integer facePhotoFlag) {
        this.facePhotoFlag = facePhotoFlag;
    }
    public String getFacePhotoExceptional() {
        return facePhotoExceptional;
    }

    public void setFacePhotoExceptional(String facePhotoExceptional) {
        this.facePhotoExceptional = facePhotoExceptional;
    }
    public Integer getWorkState() {
        return workState;
    }

    public void setWorkState(Integer workState) {
        this.workState = workState;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getIdCardName() {
        return idCardName;
    }

    public void setIdCardName(String idCardName) {
        this.idCardName = idCardName;
    }
    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getIdCardSex() {
        return idCardSex;
    }

    public void setIdCardSex(String idCardSex) {
        this.idCardSex = idCardSex;
    }

    public String getIdCardBirthDate() {
        return idCardBirthDate;
    }

    public void setIdCardBirthDate(String idCardBirthDate) {
        this.idCardBirthDate = idCardBirthDate;
    }

    public String getIdCardNation() {
        return idCardNation;
    }

    public void setIdCardNation(String idCardNation) {
        this.idCardNation = idCardNation;
    }

    public String getIdCardStartDate() {
        return idCardStartDate;
    }

    public void setIdCardStartDate(String idCardStartDate) {
        this.idCardStartDate = idCardStartDate;
    }

    public String getIdCardEndDate() {
        return idCardEndDate;
    }

    public void setIdCardEndDate(String idCardEndDate) {
        this.idCardEndDate = idCardEndDate;
    }

    public String getIdCardIssue() {
        return idCardIssue;
    }

    public void setIdCardIssue(String idCardIssue) {
        this.idCardIssue = idCardIssue;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public void setSexName(String sexName) {
        this.sexName = sexName;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
