package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.labor.vo.WorktimeSetDetailVO;

/**
 * 考勤设置
 * 
 * @author generator
 * 
 */
public class WorktimeSetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Integer offSiteFlag; // 是否允许异地打卡（1:是 0：否）
    private Boolean enable; // 是否启用（1:是 0：否）
    private String memo; // 描述
    private String addressList; // 字表地址合计
    private String enableName; // 是否启用（1:是 0：否）
    private String offSiteFlagName; // 是否允许异地打卡（1:是 0：否）
    private String attendanceAddress; // 考勤地址

    private List<WorktimeSetDetailVO> worktimeSetDetailList = new ArrayList<>(); // 考勤设置明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getOffSiteFlag() {
        return offSiteFlag;
    }

    public void setOffSiteFlag(Integer offSiteFlag) {
        this.offSiteFlag = offSiteFlag;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<WorktimeSetDetailVO> getWorktimeSetDetailList() {
        return worktimeSetDetailList;
     }

     public void setWorktimeSetDetailList(List<WorktimeSetDetailVO> worktimeSetDetailList) {
        this.worktimeSetDetailList = worktimeSetDetailList;
     }

    public String getAddressList() {
        return addressList;
    }

    public void setAddressList(String addressList) {
        this.addressList = addressList;
    }

    public String getEnableName() {
        return enableName;
    }

    public void setEnableName(String enableName) {
        this.enableName = enableName;
    }

    public String getOffSiteFlagName() {
        return offSiteFlagName;
    }

    public void setOffSiteFlagName(String offSiteFlagName) {
        this.offSiteFlagName = offSiteFlagName;
    }

    public String getAttendanceAddress() {
        return attendanceAddress;
    }

    public void setAttendanceAddress(String attendanceAddress) {
        this.attendanceAddress = attendanceAddress;
    }
}
