package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.labor.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 项目班组
 * 
 * @author generator
 * 
 */
public class ProjectTeamVO extends BaseVO{
    private static final long serialVersionUID = 1L;
    
    private Integer sourceFlag; // 来源标识（0自制、1公司班组）
    private Long sourceOrgTeamId; // 来源公司班组ID
    private String innerCode; // innerCode
    private Long parentId; // 父ID
    private String code; // 编码
    private String name; // 班组名称
    private String leaderName; // 班组长名称
    private String phone; // 手机号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织id
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgName; // 项目部所属组织
    private String memo; // 备注
    private Boolean isLeaf; // 是否是叶子节点
    private Long sourceParentId; // 来源公司班组 父ID
    private String parentCode;//上级编码
    private String parentName; //上级名称

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Long getSourceParentId() {
        return sourceParentId;
    }

    public void setSourceParentId(Long sourceParentId) {
        this.sourceParentId = sourceParentId;
    }

    public Boolean getIsLeaf() {
        return isLeaf;
    }

    public void setIsLeaf(Boolean leaf) {
        isLeaf = leaf;
    }

    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public Long getSourceOrgTeamId() {
        return sourceOrgTeamId;
    }

    public void setSourceOrgTeamId(Long sourceOrgTeamId) {
        this.sourceOrgTeamId = sourceOrgTeamId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    @ReferSerialTransfer(referCode="projectTeamRef")
    public Long getParentId() {
        return parentId;
    }
    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getLeaderName() {
        return leaderName;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
//    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
//    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
//    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
//    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
//    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
//    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
