package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.vo.BatchCheckPhotoVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 公司花名册人员
 *
 * @author generator
 */
public interface IWorkerService extends IBaseService<WorkerEntity> {

    /**
     * 公司花名册人员身份证和人脸校验定时任务
     *
     * @param request 请求
     */
    void checkTask(HttpServletRequest request);

    WorkerVO insertOrUpdate(WorkerVO vo);


    WorkerVO updateBatWorker(WorkerVO updateVO);

    Map<String, Object> getArea(String area);

    /**
     * 批量校验证件
     *
     * @param request  请求
     * @param response 响应
     *
     * @return {@link JSONObject}
     */
    JSONObject batchCheck(HttpServletRequest request, HttpServletResponse response) throws IOException, NoSuchFieldException, IllegalAccessException;

    /**
     * 更新照片数据
     *
     * @param batchCheckPhotoVOS 批量导入证件校验VO
     */
    void updatePhotoData(List<BatchCheckPhotoVO> batchCheckPhotoVOS);

    /**
     * 根据身份证查询 公司花名册对应的人员
     * @param idCard
     * @return
     */
    WorkerEntity queryOneByIdCard(String idCard);

    /**
     * 根据id 修改单据的进场状态
     * @param ids
     */
    void updateEnterStatusByIdS(List<Long> ids);

    /**
     * @description: 保存导入人员信息
     *
     * @param request
     * @param workerVOS
     * @return {@link String}
     * @author songlx
     * @date: 2022/11/22
     */
    String saveImportPerson(HttpServletRequest request, List<WorkerVO> workerVOS);

    /**
     * @description: 查询班组下的人员
     *
     * @param page
     * @param queryParam
     * @param teamId
     * @return {@link java.util.List<com.ejianc.business.labor.vo.WorkerVO>}
     * @author songlx
     * @date: 2022/11/25
     */
    List<WorkerEntity> queryOrgTeamWorkerPage(Page<WorkerEntity> page, QueryParam queryParam, Long teamId);


    /**
     * @description: 根据班组id改变劳务员工所属班组名称
     * 班组档案修改名称时，劳务员工冗余的所属班组名称没有变化
     * @param teamId 更新此班组下的所有劳务员工的teamname，适用班组名字更新
     * @param workerId 更新此劳务工人的teamname， 需要前置步骤把teamid放对先更新了
     * @return
     * @author songlx
     * @date: 2022/11/28
     */
    Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId);


    /**
     * 人脸注册
     *
     * @param workerVO 保存或更新vo
     */
    void faceRegistration(WorkerVO workerVO);

    /**
     * 删除注册的人脸
     *
     * @param workerId 公司花名册人员id
     */
    void deleteFace(Long workerId);
}
