/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorktimeSetEntity;
import com.ejianc.business.labor.mapper.WorktimeSetMapper;
import com.ejianc.business.labor.service.IWorktimeSetService;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="worktimeSetService")
public class WorktimeSetServiceImpl
extends BaseServiceImpl<WorktimeSetMapper, WorktimeSetEntity>
implements IWorktimeSetService {
    private static final String QR_CODE_LOGIN_URL = "ejc-labor-mobile/#/qrCodeLogin";
    private static final String CODE = "Weixin";
    private static final String SCOPE = "snsapi_base";
    private static final String STATE = "123";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Resource
    private IThirdSystemApi thirdSystemApi;

    @Override
    public JSONObject getQrCode(Long id) throws UnsupportedEncodingException {
        Assert.notNull((Object)id, (String)"\u8003\u52e4\u8bbe\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        WorktimeSetEntity entity = (WorktimeSetEntity)((Object)super.selectById((Serializable)id));
        Assert.notNull((Object)((Object)entity), (String)"\u8003\u52e4\u8bbe\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject resp = new JSONObject();
        String sb = "?worktimeSetId=" + id + "&tenantId=" + entity.getTenantId() + "&projectId=" + entity.getProjectId() + "&projectName=" + entity.getProjectName();
        String redirectUri = this.BaseHost + QR_CODE_LOGIN_URL + sb;
        String redirectUrl = URLEncoder.encode(redirectUri, "UTF-8");
        resp.put("mobileH5Url", (Object)redirectUrl);
        resp.put("mobileWxUrl", (Object)redirectUrl);
        return resp;
    }
}

