/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.WagesEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.mapper.WagesMapper;
import com.ejianc.business.labor.service.IWagesService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.vo.WagesReportVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wagesService")
public class WagesServiceImpl
extends BaseServiceImpl<WagesMapper, WagesEntity>
implements IWagesService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private IWagesService wagesService;

    @Override
    public IPage<WagesReportVO> queryReportList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        CommonResponse response = this.projectApi.queryProjectPage(param);
        List wagesEntities = this.wagesService.list();
        if (response.isSuccess() && null != response.getData()) {
            Page pageData = (Page)response.getData();
            Page page = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
            ArrayList<WagesReportVO> list = new ArrayList<WagesReportVO>();
            for (ProjectRegisterVO registerVO : pageData.getRecords()) {
                WagesReportVO reportVO = new WagesReportVO();
                reportVO.setId(registerVO.getId());
                reportVO.setProjectCode(registerVO.getCode());
                reportVO.setProjectName(registerVO.getName());
                reportVO.setProjectManagerName(registerVO.getProjectManagerName());
                reportVO.setCostTotalMny(ComputeUtil.safeDiv((BigDecimal)registerVO.getCostTotal(), (BigDecimal)BigDecimal.valueOf(10000L)));
                CommonResponse membersResp = this.userApi.getEmployeeList(registerVO.getProjectDepartmentId());
                if (membersResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)membersResp.getData()))) {
                    ArrayList<String> nameList = new ArrayList<String>();
                    for (Map map : (List)membersResp.getData()) {
                        if (null == map.get("roleName") || !"\u52b3\u52a1\u5458".equals((String)map.get("roleName"))) continue;
                        nameList.add(String.valueOf(map.get("userName")));
                    }
                    if (CollectionUtils.isNotEmpty(nameList)) {
                        reportVO.setLaborName(StringUtils.join(nameList, (String)","));
                    }
                }
                int littleNum = 0;
                int midNum = 0;
                int bigNum = 0;
                int biggestNum = 0;
                int littlestNum = 0;
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(WorkerEnterEntity::getProjectId, (Object)registerVO.getId());
                queryWrapper.eq(WorkerEnterEntity::getWorkState, (Object)1);
                queryWrapper.eq(WorkerEnterEntity::getEnabled, (Object)1);
                queryWrapper.in(WorkerEnterEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                List entities = this.workerEnterService.list((Wrapper)queryWrapper);
                for (WorkerEnterEntity entity : entities) {
                    String result;
                    switch (result = this.judgeMatch(entity.getWage(), wagesEntities)) {
                        case "\u5c0f\u5de5": {
                            ++littleNum;
                            break;
                        }
                        case "\u4e2d\u5de5": {
                            ++midNum;
                            break;
                        }
                        case "\u5927\u5de5": {
                            ++bigNum;
                            break;
                        }
                        case "\u8d85\u9ad8": {
                            ++biggestNum;
                            break;
                        }
                        case "\u8d85\u4f4e": {
                            ++littlestNum;
                            break;
                        }
                    }
                }
                int total = littleNum + midNum + bigNum + biggestNum + littlestNum;
                if (total != 0) {
                    reportVO.setLittleScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(littleNum / total), (BigDecimal)BigDecimal.valueOf(100L)));
                    reportVO.setMidScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(midNum / total), (BigDecimal)BigDecimal.valueOf(100L)));
                    reportVO.setBigScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(bigNum / total), (BigDecimal)BigDecimal.valueOf(100L)));
                    reportVO.setBiggestScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(biggestNum / total), (BigDecimal)BigDecimal.valueOf(100L)));
                    reportVO.setLittlestScale(ComputeUtil.safeMultiply((BigDecimal)BigDecimal.valueOf(littlestNum / total), (BigDecimal)BigDecimal.valueOf(100L)));
                }
                list.add(reportVO);
            }
            page.setRecords(list);
            return page;
        }
        return new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
    }

    private String judgeMatch(BigDecimal mny, List<WagesEntity> wagesEntities) {
        for (WagesEntity wages : wagesEntities) {
            if (null != wages.getLowerMny() && !ComputeUtil.isGreaterThan((BigDecimal)mny, (BigDecimal)wages.getLowerMny()) || null != wages.getHighestMny() && !ComputeUtil.isLessOrEqual((BigDecimal)mny, (BigDecimal)wages.getHighestMny())) continue;
            return wages.getJobs();
        }
        return "";
    }
}

