package com.ejianc.business.labor.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 公司花名册人员
 *
 * @author generator
 */
@TableName("ejc_labor_worker")
public class WorkerEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 姓名
    @TableField(value="code")
    private String code; // 编码
    @TableField(value="id_card")
    private String idCard; // 身份证号
    @TableField(value="sex")
    private Integer sex; // 1-男，2-女
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="birth_date")
    private Date birthDate; // 出生日期
    @TableField(value="nation")
    private String nation; // 民族
    @TableField(value="phone")
    private String phone; // 手机号
    @TableField(value="team_id")
    private String teamId; // 劳务班组
    @TableField(value="team_name")
    private String teamName; // 劳务班组名称
    @TableField(value="work_type")
    private String workType; // 工种
    @TableField(value="work_type_name")
    private String workTypeName; // 工种名称
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="bank_account")
    private String bankAccount; // 银行账号
    @TableField(value="wages_type")
    private Integer wagesType; // 工资类型
    @TableField(value="wages_type_name")
    private String wagesTypeName; // 工资类型名称
    @TableField(value="wage")
    private BigDecimal wage; // 工价
    @TableField(value="province")
    private String province; // 省
    @TableField(value="city")
    private String city; // 市
    @TableField(value="area")
    private String area; // 省市
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="source_flag")
    private Integer sourceFlag; // 来源：1-公司自制，2-项目进场
    @TableField(value="source_flag_name")
    private String sourceFlagName; // 来源名称（固定显示的公司自制或第一个项目名称）
    @TableField(value="source_project_id")
    private Long sourceProjectId; // 来源项目id
    @TableField(value="last_project_id")
    private Long lastProjectId; // 最后更新的项目id
    @TableField(value="id_card_front_photo_flag")
    private Integer idCardFrontPhotoFlag; // 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
    @TableField(value="id_card_front_photo_exceptional")
    private String idCardFrontPhotoExceptional; // 身份证正面异常信息
    @TableField(value="id_card_back_photo_flag")
    private Integer idCardBackPhotoFlag; // 身份证反面照片状态：0-待校验，1-是，2-否，3-异常
    @TableField(value="id_card_back_photo_exceptional")
    private String idCardBackPhotoExceptional; // 身份证反面异常信息
    @TableField(value="face_photo_flag")
    private Integer facePhotoFlag; // 人脸采集状态：0-待校验，1-是，2-否，3-异常
    @TableField(value="face_photo_exceptional")
    private String facePhotoExceptional; // 人脸采集异常信息
    @TableField(value="work_state")
    private Integer workState; // 用工状态：0未入场，1已入场
    @TableField(value="enabled")
    private Integer enabled; // 1:启用/0:停用
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="id_card_name")
    private String idCardName; // 身份证照片识别的姓名
    @TableField(value = "id_card_no")
    private String idCardNo; // 身份证照片识别的身份证号
    @TableField(value = "id_card_sex")
    private String idCardSex; // 身份证照片识别的性别，1-男，2-女
    @TableField(value = "id_card_birth_date")
    private String idCardBirthDate; // 身份证照片识别的出生年月
    @TableField(value = "id_card_nation")
    private String idCardNation; // 身份证照片识别的民族
    @TableField(value = "id_card_start_date")
    private String idCardStartDate; // 身份证照片识别的起始有效期
    @TableField(value = "id_card_end_date")
    private String idCardEndDate; // 身份证照片识别的截止有效期
    @TableField(value = "id_card_issue")
    private String idCardIssue; // 身份证照片识别的签发机关

    @TableField(value="overtime_wage")
    private BigDecimal overtimeWage; // 加班工价
    @TableField(value="emergency_contact")
    private String emergencyContact; // 紧急联系人
    @TableField(value="buy_flag")
    private Integer buyFlag; // 是否代买保险

    @TableField(value="work_category")
    private Long workCategory; // 工类
    @TableField(value="work_category_name")
    private String workCategoryName; // 工类名称
    @TableField(value="plan_province")
    private String planProvince;//银行所属省
    @TableField(value="plan_city")
    private String planCity;//银行所属市

    public String getPlanProvince() {
        return planProvince;
    }

    public void setPlanProvince(String planProvince) {
        this.planProvince = planProvince;
    }

    public String getPlanCity() {
        return planCity;
    }

    public void setPlanCity(String planCity) {
        this.planCity = planCity;
    }

    public String getEmergencyContact() {
        return emergencyContact;
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact;
    }

    public Integer getBuyFlag() {
        return buyFlag;
    }

    public void setBuyFlag(Integer buyFlag) {
        this.buyFlag = buyFlag;
    }

    public Long getWorkCategory() {
        return workCategory;
    }

    public void setWorkCategory(Long workCategory) {
        this.workCategory = workCategory;
    }

    public String getWorkCategoryName() {
        return workCategoryName;
    }

    public void setWorkCategoryName(String workCategoryName) {
        this.workCategoryName = workCategoryName;
    }

    public BigDecimal getOvertimeWage() {
        return overtimeWage;
    }

    public void setOvertimeWage(BigDecimal overtimeWage) {
        this.overtimeWage = overtimeWage;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getTeamId() {
        return teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public Integer getWagesType() {
        return wagesType;
    }

    public void setWagesType(Integer wagesType) {
        this.wagesType = wagesType;
    }
    public String getWagesTypeName() {
        return wagesTypeName;
    }

    public void setWagesTypeName(String wagesTypeName) {
        this.wagesTypeName = wagesTypeName;
    }
    public BigDecimal getWage() {
        return wage;
    }

    public void setWage(BigDecimal wage) {
        this.wage = wage;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Integer getSourceFlag() {
        return sourceFlag;
    }

    public void setSourceFlag(Integer sourceFlag) {
        this.sourceFlag = sourceFlag;
    }
    public String getSourceFlagName() {
        return sourceFlagName;
    }

    public void setSourceFlagName(String sourceFlagName) {
        this.sourceFlagName = sourceFlagName;
    }
    public Long getSourceProjectId() {
        return sourceProjectId;
    }

    public void setSourceProjectId(Long sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }
    public Long getLastProjectId() {
        return lastProjectId;
    }

    public void setLastProjectId(Long lastProjectId) {
        this.lastProjectId = lastProjectId;
    }
    public Integer getIdCardFrontPhotoFlag() {
        return idCardFrontPhotoFlag;
    }

    public void setIdCardFrontPhotoFlag(Integer idCardFrontPhotoFlag) {
        this.idCardFrontPhotoFlag = idCardFrontPhotoFlag;
    }
    public String getIdCardFrontPhotoExceptional() {
        return idCardFrontPhotoExceptional;
    }

    public void setIdCardFrontPhotoExceptional(String idCardFrontPhotoExceptional) {
        this.idCardFrontPhotoExceptional = idCardFrontPhotoExceptional;
    }
    public Integer getIdCardBackPhotoFlag() {
        return idCardBackPhotoFlag;
    }

    public void setIdCardBackPhotoFlag(Integer idCardBackPhotoFlag) {
        this.idCardBackPhotoFlag = idCardBackPhotoFlag;
    }
    public String getIdCardBackPhotoExceptional() {
        return idCardBackPhotoExceptional;
    }

    public void setIdCardBackPhotoExceptional(String idCardBackPhotoExceptional) {
        this.idCardBackPhotoExceptional = idCardBackPhotoExceptional;
    }
    public Integer getFacePhotoFlag() {
        return facePhotoFlag;
    }

    public void setFacePhotoFlag(Integer facePhotoFlag) {
        this.facePhotoFlag = facePhotoFlag;
    }
    public String getFacePhotoExceptional() {
        return facePhotoExceptional;
    }

    public void setFacePhotoExceptional(String facePhotoExceptional) {
        this.facePhotoExceptional = facePhotoExceptional;
    }
    public Integer getWorkState() {
        return workState;
    }

    public void setWorkState(Integer workState) {
        this.workState = workState;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getIdCardName() {
        return idCardName;
    }

    public void setIdCardName(String idCardName) {
        this.idCardName = idCardName;
    }
    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public String getIdCardSex() {
        return idCardSex;
    }

    public void setIdCardSex(String idCardSex) {
        this.idCardSex = idCardSex;
    }

    public String getIdCardBirthDate() {
        return idCardBirthDate;
    }

    public void setIdCardBirthDate(String idCardBirthDate) {
        this.idCardBirthDate = idCardBirthDate;
    }

    public String getIdCardNation() {
        return idCardNation;
    }

    public void setIdCardNation(String idCardNation) {
        this.idCardNation = idCardNation;
    }

    public String getIdCardStartDate() {
        return idCardStartDate;
    }

    public void setIdCardStartDate(String idCardStartDate) {
        this.idCardStartDate = idCardStartDate;
    }

    public String getIdCardEndDate() {
        return idCardEndDate;
    }

    public void setIdCardEndDate(String idCardEndDate) {
        this.idCardEndDate = idCardEndDate;
    }

    public String getIdCardIssue() {
        return idCardIssue;
    }

    public void setIdCardIssue(String idCardIssue) {
        this.idCardIssue = idCardIssue;
    }
}
