package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.mapper.OrgTeamMapper;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 公司花名册班组
 *
 * @author generator
 *
 */
@Service("orgTeamService")
public class OrgTeamServiceImpl extends BaseServiceImpl<OrgTeamMapper, OrgTeamEntity> implements IOrgTeamService {

    @Autowired
    private OrgTeamMapper orgTeamMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LABOR_ORG_TEAM";//此处需要根据实际修改

    @Autowired
    private IWorkerService workerService;

    @Override
    public List<OrgTeamVO> queryListTree(Map<String, Object> params) {
        List<OrgTeamVO> orgTeamList = orgTeamMapper.queryListTree(params);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<OrgTeamVO> orgTeamList = orgTeamMapper.queryListByPid(tenantId, id);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryCategoryListByIds(List<Long> ids) {
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<OrgTeamVO> orgTeamList = orgTeamMapper.queryListByIds(params);
        return orgTeamList;
    }

    @Override
    public OrgTeamVO insertOrUpdate(OrgTeamVO saveOrUpdateVO) {
        OrgTeamEntity entity = BeanMapper.map(saveOrUpdateVO, OrgTeamEntity.class);
        Long parentId = entity.getParentId();
        String name = entity.getName();
        Long id = entity.getId();
        OrgTeamEntity _orgTeamEntity = null;
        if ( id == null || id == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {

            //修改时，需要获取老的父级节点，如果换了父级节点，老的父级节点也需要更新IsLeaf
            _orgTeamEntity = this.selectById(entity.getId());
            Long oldParentId = _orgTeamEntity.getParentId();
            if(oldParentId != null && !oldParentId.equals(parentId)){
                LambdaUpdateWrapper<OrgTeamEntity> countParentWrapper = new LambdaUpdateWrapper<>();
                countParentWrapper.eq(OrgTeamEntity::getParentId, oldParentId);
                countParentWrapper.ne(OrgTeamEntity::getId, entity.getId());
                int countOldParentNum = this.count(countParentWrapper);
                LambdaUpdateWrapper<OrgTeamEntity> parentWrapper = new LambdaUpdateWrapper<>();
                //修改父级的是否叶子节点字段
                parentWrapper.set(OrgTeamEntity::getIsLeaf, countOldParentNum > 0 ? false : true);
                parentWrapper.eq(OrgTeamEntity::getId, oldParentId);
                this.update(parentWrapper);
            }
        }

        super.saveOrUpdate(entity, false);
        LambdaUpdateWrapper<OrgTeamEntity> curWrapper = new LambdaUpdateWrapper<>();
        curWrapper.eq(OrgTeamEntity::getId, entity.getId());
        String innerCode = entity.getId().toString();
        if (parentId != null) {
            //当前新增的父级不为空时，设置父级的isLeaf字段为非叶子节点
            LambdaUpdateWrapper<OrgTeamEntity> parentWrapper = new LambdaUpdateWrapper<>();
            //修改父级的是否叶子节点字段
            parentWrapper.set(OrgTeamEntity::getIsLeaf, false);
            parentWrapper.eq(OrgTeamEntity::getId, parentId);
            this.update(parentWrapper);

            //修改当前节点的内码
            OrgTeamEntity parentEntity = this.selectById(entity.getParentId());
            innerCode = parentEntity.getInnerCode() + "|" + entity.getId();
            curWrapper.set(OrgTeamEntity::getParentCode, parentEntity.getCode());
        }
        curWrapper.set(OrgTeamEntity::getInnerCode, innerCode);

        //查询是否有子集，有子集存在更新innerCode的情况
        LambdaQueryWrapper<OrgTeamEntity> childQueryWrapper = new LambdaQueryWrapper<>();
        childQueryWrapper.ne(OrgTeamEntity::getId, entity.getId());
        childQueryWrapper.likeRight(OrgTeamEntity::getInnerCode, entity.getInnerCode());
        List<OrgTeamEntity> childList = this.list(childQueryWrapper);
        if (CollectionUtils.isNotEmpty(childList)) {
            for (OrgTeamEntity childOrgTeamEntity : childList) {
                LambdaUpdateWrapper<OrgTeamEntity> childUpdWrapper = new LambdaUpdateWrapper<>();
                childUpdWrapper.set(OrgTeamEntity::getInnerCode, innerCode + "|" + childOrgTeamEntity.getId());
                childUpdWrapper.eq(OrgTeamEntity::getId, childOrgTeamEntity.getId());
                this.update(childUpdWrapper);
            }
            //有子集，叶子结点标识置为false
            curWrapper.set(OrgTeamEntity::getIsLeaf, Boolean.FALSE);
        } else {
            curWrapper.set(OrgTeamEntity::getIsLeaf, Boolean.TRUE);
        }

        boolean update = this.update(curWrapper);
        if(id != null && _orgTeamEntity != null && update){
            //修改时，需要判断班组名称是否修改了，如果修改了，那么劳务员工中所属班组冗余班组名称也需要修改
            String oldName = _orgTeamEntity.getName();
            if(StringUtils.isNotEmpty(oldName) && !oldName.equals(name)){
                workerService.updateWorkerTeamNameByTeamIdOrWorkerId(id,null);
            }
        }
        OrgTeamVO vo = BeanMapper.map(entity, OrgTeamVO.class);
        return vo;
    }

}
