package com.ejianc.business.labor.controller;

import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @description: LaborStatisticController
 * @author songlx
 * @date 2024/11/11
 * @version 1.0
 */
@Controller
@RequestMapping("laborStatistic")
public class LaborStatisticController  implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IWorkRecordService workRecordService;

    /**
     * @Description 劳务实名制人数统计
     */
    @RequestMapping(value = "/workerCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> workerCount() {
        return CommonResponse.success("劳务实名制人数统计！", workRecordService.workerCount());
    }


    /**
     * @Description 工种占比
     */
    @RequestMapping(value = "/workerScale", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> workerScale() {
        return CommonResponse.success("查询工种占比！", workRecordService.workerScale());
    }



}
