package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.WagesEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.mapper.WagesMapper;
import com.ejianc.business.labor.service.IWagesService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.vo.WagesReportVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 工资分布比例设置
 *
 * @author generator
 */
@Service("wagesService")
public class WagesServiceImpl extends BaseServiceImpl<WagesMapper, WagesEntity> implements IWagesService {

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IWagesService wagesService;

    @Override
    public IPage<WagesReportVO> queryReportList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        CommonResponse<Page<ProjectRegisterVO>> response = projectApi.queryProjectPage(param);
        List<WagesEntity> wagesEntities = wagesService.list();
        if (response.isSuccess() && null != response.getData()) {
            Page<ProjectRegisterVO> pageData = response.getData();
            IPage<WagesReportVO> page = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
            List<WagesReportVO> list = new ArrayList<>();
            for (ProjectRegisterVO registerVO : pageData.getRecords()) {
                WagesReportVO reportVO = new WagesReportVO();
                reportVO.setId(registerVO.getId());
                reportVO.setProjectCode(registerVO.getCode());
                reportVO.setProjectName(registerVO.getName());
                reportVO.setProjectManagerName(registerVO.getProjectManagerName());
                reportVO.setCostTotalMny(ComputeUtil.safeDiv(registerVO.getCostTotal(), BigDecimal.valueOf(10000)));
                //查询项目成员
                CommonResponse<List<Map<String, Object>>> membersResp = userApi.getEmployeeList(registerVO.getProjectDepartmentId());
                if (membersResp.isSuccess() && CollectionUtils.isNotEmpty(membersResp.getData())) {
                    List<String> nameList = new ArrayList<>();
                    for (Map<String, Object> map : membersResp.getData()) {
                        if (null != map.get("roleName") && "劳务员".equals((String) map.get("roleName"))) {
                            nameList.add(String.valueOf(map.get("userName")));
                        }
                    }
                    if (CollectionUtils.isNotEmpty(nameList)) {
                        reportVO.setLaborName(StringUtils.join(nameList, ","));
                    }
                }
                int littleNum = 0; // 小工比例
                int midNum = 0; // 中工比例
                int bigNum = 0; // 大工比例
                int biggestNum = 0; // 超高工价比例
                int littlestNum = 0; // 超低工价比例
                LambdaQueryWrapper<WorkRecordEntity> queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(WorkRecordEntity::getProjectId, registerVO.getId());
                queryWrapper.eq(WorkRecordEntity::getEnterExitState, 1);
                List<WorkRecordEntity> entities = workRecordService.list(queryWrapper);
                for (WorkRecordEntity entity : entities) {
                    String result = judgeMatch(entity.getWage(), wagesEntities);
                    switch (result) {
                        case "小工":
                            littleNum++;
                            break;
                        case "中工":
                            midNum++;
                            break;
                        case "大工":
                            bigNum++;
                            break;
                        case "超高":
                            biggestNum++;
                            break;
                        case "超低":
                            littlestNum++;
                            break;
                        default:
                    }
                }
                int total = littleNum + midNum + bigNum + biggestNum + littlestNum;
                if (total != 0) {
                    reportVO.setLittleScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(BigDecimal.valueOf(littleNum), BigDecimal.valueOf(total)), BigDecimal.valueOf(100)));
                    reportVO.setMidScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(BigDecimal.valueOf(midNum), BigDecimal.valueOf(total)), BigDecimal.valueOf(100)));
                    reportVO.setBigScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(BigDecimal.valueOf(bigNum), BigDecimal.valueOf(total)), BigDecimal.valueOf(100)));
                    reportVO.setBiggestScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(BigDecimal.valueOf(biggestNum), BigDecimal.valueOf(total)), BigDecimal.valueOf(100)));
                    reportVO.setLittlestScale(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(BigDecimal.valueOf(littlestNum), BigDecimal.valueOf(total)), BigDecimal.valueOf(100)));
                }
                list.add(reportVO);
            }
            page.setRecords(list);
            return page;
        }
        return new Page<>(param.getPageIndex(), param.getPageSize(), 0);
    }

    private String judgeMatch(BigDecimal mny, List<WagesEntity> wagesEntities) {
        for (WagesEntity wages : wagesEntities) {
            if ((null == wages.getLowerMny() || ComputeUtil.isGreaterThan(mny, wages.getLowerMny())) && (null == wages.getHighestMny() || ComputeUtil.isLessOrEqual(mny, wages.getHighestMny()))) {
                return wages.getJobs();
            }
        }
        return "";
    }
}
