package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公司花名册人员
 *
 * @author generator
 *
 */
@Validated
@RestController
@RequestMapping("worker")
public class WorkerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWorkerService service;

    @Autowired
    private IOrgTeamService orgTeamService;

    @Autowired
    private IWorkerRegisterService workerRegisterService;

    @Autowired
    private SessionManager sessionManager;

    @Resource
    private IIdCardService iIdCardService;

    @Resource
    private IFaceService faceService;

    private static final String BILL_CODE = "LABOR_WORKER";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> saveOrUpdate(@RequestBody WorkerVO saveOrUpdateVO) {
        WorkerVO vo = service.insertOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     *  批量修改人员的班组和工种
     * @param updateVO
     * @return
     */
    @RequestMapping(value = "/updateBatWorker", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> updateBatWorker(@RequestBody WorkerVO updateVO){
        WorkerVO vo = service.updateBatWorker(updateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkerVO> queryDetail(Long id) {
    	WorkerEntity entity = service.selectById(id);
    	WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> delIds = vos.stream().map(WorkerVO::getId).collect(Collectors.toList());
        service.removeByIds(delIds,true);
        //删除成功后，同时删除该人员在中间表的数据
        LambdaUpdateWrapper<WorkerRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(WorkerRegisterEntity::getDr,1);
        updateWrapper.in(WorkerRegisterEntity::getWorkerId,delIds);
        workerRegisterService.update(updateWrapper);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> params = param.getParams();
        if(params.containsKey("teamId")){
            Object teamId = params.get("teamId").getValue();
            LambdaQueryWrapper<WorkerRegisterEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.like(WorkerRegisterEntity::getTeamInnerCode,String.valueOf(teamId));
            List<WorkerRegisterEntity> list = workerRegisterService.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                param.getParams().put("id",new Parameter(QueryParam.IN,list.stream().map(WorkerRegisterEntity::getWorkerId).collect(Collectors.toList())));
                param.getParams().remove("teamId");
            }
        }

        IPage<WorkerEntity> page = service.queryPage(param,false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Worker-export.xlsx", beans, response);
    }

    /**
     * 分页查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "refWorkerPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                         @RequestParam(required = false) String relyCondition,
                                                         @RequestParam(required = false) String searchText,
                                                         @RequestParam(required = false) String condition,
                                                         @RequestParam(required = false) String searchObject) {
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            OrgTeamEntity orgTeam = orgTeamService.getById(categoryId);
            if (orgTeam != null) {
                params.put("innerCode", orgTeam.getInnerCode());
            }else{
                return CommonResponse.error("当前班组不存在档案！");
            }
        }
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("categoryCode") != null) {
                params.put("categoryCode", search.get("categoryCode").toString());
            }
            if (search.get("categoryName") != null) {
                params.put("categoryName", search.get("categoryName").toString());
            }
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<WorkerVO> pageData = service.queryRefOrgTeamPage(params);
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        return CommonResponse.success("查询成功！", pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkerEntity> page = service.queryPage(param, false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 校验身份证以及身份证信息识别
     *
     * @param imageUrl 身份证阿里oss存储在线地址
     * @param side     face：人像面  back：国徽面
     *
     * @return {@link CommonResponse}<{@link IdentityCardInfoVO}>
     */
    @GetMapping(value = "checkAndRecognizeIdentityCardInfo")
    public CommonResponse<IdentityCardInfoVO> checkAndRecognizeIdentityCardInfo(@RequestParam(value = "imageUrl") String imageUrl,
                                                                                @RequestParam(value = "side") String side) {
        return CommonResponse.success("校验身份证以及身份证信息识别，成功！", iIdCardService.checkAndRecognizeIdentityCardInfo(imageUrl, side));
    }

    /**
     * 人脸活体校验
     *
     * @param faceInfoVO 人脸信息VO
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @PostMapping(value = "checkFaceQualityAndLive")
    public CommonResponse<Boolean> checkFaceQualityAndLive(@Validated(value = {CustomValidateGroup.Crud.Create.class}) @RequestBody FaceInfoVO faceInfoVO) {
        return CommonResponse.success("人脸活体校验，成功！", faceService.checkFaceQualityAndLive(faceInfoVO));
    }

    /**
     * 公司花名册人员身份证和人脸校验定时任务
     *
     * @param request 请求
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @PostMapping(value = "/checkTask")
    public CommonResponse<Void> checkTask(HttpServletRequest request) {
        service.checkTask(request);
        return CommonResponse.success("定时任务，身份证和人脸校验执行成功！");
    }

}
