package com.ejianc.business.labor.service;

import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.vo.ProjectTeamVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 项目班组
 * 
 * @author generator
 * 
 */
public interface IProjectTeamService extends IBaseService<ProjectTeamEntity> {



    List<ProjectTeamVO> queryListTree(Map<String, Object> params);

    List<ProjectTeamVO> queryListByPid(Long pid);

    List<ProjectTeamVO> queryCategoryListByIds(List<Long> asList);
    ProjectTeamVO insertOrUpdate(ProjectTeamVO saveOrUpdateVO);


    /**
     * 引入班组逻辑
     *  引入班组时，查询公司班组树。根节点不可选中，其他节点都可选。已经引入的班组不可再次引入；
     * 当第一次只引入子级，下次引入父级时，需要按公司班组构造树形；
     * @param voList
     * @return
     */
    List<String> insertProjectTeam(List<ProjectTeamVO> voList);
}
