package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.labor.mapper.ProjectTeamMapper;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.business.labor.vo.ProjectTeamVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目班组
 * 
 * @author generator
 * 
 */
@Service("projectTeamService")
public class ProjectTeamServiceImpl extends BaseServiceImpl<ProjectTeamMapper, ProjectTeamEntity> implements IProjectTeamService{

    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";//此处需要根据实际修改
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ProjectTeamMapper projectTeamMapper;

    @Override
    public List<ProjectTeamVO> queryListTree(Map<String, Object> params) {
        List<ProjectTeamVO> orgTeamList = projectTeamMapper.queryListTree(params);
        return orgTeamList;
    }

    @Override
    public List<ProjectTeamVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ProjectTeamVO> orgTeamList =  projectTeamMapper.queryListByPid(tenantId, id);
        return orgTeamList;
    }

    @Override
    public List<ProjectTeamVO> queryCategoryListByIds(List<Long> ids) {
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<ProjectTeamVO> orgTeamList =  projectTeamMapper.queryListByIds(params);
        return orgTeamList;
    }

    @Override
    public ProjectTeamVO insertOrUpdate(ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectTeamEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
        }
        if (entity.getSourceFlag()==null){
            entity.setSourceFlag(0);
        }
        entity.setIsLeaf(true);
        super.saveOrUpdate(entity, false);
        Long parentId = entity.getParentId();
        if(parentId!=null){
            LambdaUpdateWrapper<ProjectTeamEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ProjectTeamEntity::getIsLeaf,false);
            wrapper.eq(ProjectTeamEntity::getId,parentId);
            super.update(wrapper);
        }
        ProjectTeamVO vo = BeanMapper.map(entity, ProjectTeamVO.class);
        return vo;
    }


    /**
     * 引入班组逻辑
     *  引入班组时，查询公司班组树。根节点不可选中，其他节点都可选。已经引入的班组不可再次引入；
     * 当第一次只引入子级，下次引入父级时，需要按公司班组构造树形；
     * @param voList
     * @return
     */
    @Override
    public List<String> insertProjectTeam(List<ProjectTeamVO> voList){

        //填充项目数据
        CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectByProjectDepartmentId(InvocationInfoProxy.getOrgId().toString());
        if(!projectRegisterVOCommonResponse.isSuccess()) {
            throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
        }
        ProjectRegisterVO project = projectRegisterVOCommonResponse.getData();


        List<String> errorMsg = new ArrayList<>();
        for (ProjectTeamVO vo:voList){
            //根据班组去查询是否存在
            LambdaQueryWrapper<ProjectTeamEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ProjectTeamEntity::getSourceOrgTeamId,vo.getSourceOrgTeamId());
            lambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
            int count = super.count(lambda);
            if (count<0){
                //提示当前不能插入已存在
                errorMsg.add("当前"+ vo.getName()+"已存在");
            }else {
                ProjectTeamEntity entity = BeanMapper.map(vo, ProjectTeamEntity.class);
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),vo);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(!billCode.isSuccess()) {
                    errorMsg.add("网络异常， 编码生成失败， 请稍后再试");
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                //判断是否存在子级
                LambdaQueryWrapper<ProjectTeamEntity> childCount = new LambdaQueryWrapper<>();
                childCount.eq(ProjectTeamEntity::getParentId,vo.getId());
                int countFlag = super.count(childCount);
                if (countFlag>0){
                    entity.setIsLeaf(false);
                }
                super.saveOrUpdate(entity);
                //调整父级
                Long parentId = entity.getParentId();
                if(parentId!=null){
                    LambdaUpdateWrapper<ProjectTeamEntity> wrapper = new LambdaUpdateWrapper<>();
                    wrapper.set(ProjectTeamEntity::getIsLeaf,false);
                    wrapper.eq(ProjectTeamEntity::getId,parentId);
                    super.update(wrapper);
                }
            }
        }
        return errorMsg;
    }

//detailList.stream().collect(Collectors.toMap(PaymentApplyDetailEntity::getSourceId, detailEntity -> detailEntity));
    void test(){

    }
}
