package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.WorkRecordMapper;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IWorkRecordService;

import java.util.ArrayList;
import java.util.List;

/**
 * 用工记录
 * 
 * @author generator
 * 
 */
@Service("workRecordService")
public class WorkRecordServiceImpl extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity> implements IWorkRecordService{


    /**
     * 公司推送 设置:
     *      teamId teamName orgTeamId orgTeamName
     *      workType workTypeName orgWorkType  orgWorkTypeName
     *      TeamInnerCode orgTeamInnerCode
     *
     *
     * 项目推送 设置:
     *      teamId teamName projectTeamId projectTeamName
     *      workType workTypeName projectWorkType projectWorkTypeName
     *      TeamInnerCode projectTeamInnerCode
     *
     *
     * 设置来源: sourceFlag 来源（1自制-劳务进场单、2公司花名册、3邀请）
     * @param voList
     * @return
     */
    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList){
        List<WorkRecordVO> returnList = new ArrayList<>();
        for (WorkRecordVO vo:voList){
            //根据用户 id 查询
            QueryWrapper<WorkRecordEntity> query = new QueryWrapper<>();
            query.eq("project_id", vo.getPhone());
            query.eq("last_flag", LastFlagEnum.是.getStatus());
            WorkRecordEntity one = super.getOne(query);
            //存在修改旧的
            if (one!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(WorkRecordEntity::getLastFlag,LastFlagEnum.否.getStatus());
                wrapper.eq(WorkRecordEntity::getId,one.getId());
                super.update(wrapper);
            }
            WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
            entity.setLastFlag(LastFlagEnum.是.getStatus());
            super.saveOrUpdate(entity);
            WorkRecordVO recordVO = BeanMapper.map(entity, WorkRecordVO.class);
            returnList.add(recordVO);
        }
        return returnList;
    }

    /**
     *
     * @param vo
     * @return
     */
    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        return null;
    }
}
