package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.mapper.WorkerEnterMapper;
import com.ejianc.business.labor.mapper.WorkerMapper;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公司花名册人员
 *
 * @author generator
 */
@Service("workerService")
public class WorkerServiceImpl extends BaseServiceImpl<WorkerMapper, WorkerEntity> implements IWorkerService {
	private static final String BILL_TYPE = "BT202211000007";
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Resource
	private IIdCardService idCardService;
	@Resource
	private IFaceService faceService;
	@Resource
	private WorkerMapper workerMapper;
	@Resource
	private WorkerEnterMapper workerEnterMapper;
	@Resource
	private IAttachmentApi attachmentApi;

	@Autowired
	private IOrgTeamService orgTeamService;
	@Autowired
	private IWorkerRegisterService workerRegisterService;
	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String BILL_CODE = "LABOR_WORKER";//此处需要根据实际修改

	/**
	 * 公司花名册人员身份证和人脸校验定时任务
	 *
	 * @param request 请求
	 */
	@Override
	public void checkTask(HttpServletRequest request) {
		logger.info("定时任务，身份证和人脸校验，start！");

		// 查询待检测的公司花名册人员
		LambdaQueryWrapper<WorkerEntity> lambdaQuery = Wrappers.lambdaQuery();
		lambdaQuery.eq(WorkerEntity::getIdCardFrontPhotoFlag, 0)
				.or().eq(WorkerEntity::getIdCardBackPhotoFlag, 0)
				.or().eq(WorkerEntity::getFacePhotoFlag, 0);
		List<WorkerEntity> workerEntityList = workerMapper.selectList(lambdaQuery);

		// 校验身份证和人脸
		if (CollectionUtils.isNotEmpty(workerEntityList)) {
			for (WorkerEntity entity : workerEntityList) {
				// 1.校验身份证人像面
				if (entity.getIdCardFrontPhotoFlag() == 0) {
					// 获取身份证人像面图片地址
					CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "idCardFront", null);
					if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
						logger.info("获取身份证人像面图片地址，入参：sourceId-{}，billType-{}", entity.getId(), BILL_TYPE);
					} else {
						List<AttachmentVO> faceAttachmentVOList = response.getData();
						AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);

						try {
							IdentityCardInfoVO identityCardInfoVO = idCardService.checkAndRecognizeIdentityCardInfo(faceAttachmentVO.getTruePath(), "face");
							if (identityCardInfoVO != null) {
								entity.setIdCardFrontPhotoFlag(1);
								entity.setIdCardName(identityCardInfoVO.getName());
								entity.setIdCardNo(identityCardInfoVO.getIdNumber());
								entity.setIdCardSex(identityCardInfoVO.getGender());
								entity.setIdCardBirthDate(identityCardInfoVO.getBirthDate());
								entity.setIdCardNation(identityCardInfoVO.getNationality());
							}
						} catch (Exception e) {
							logger.info("定时任务，校验身份证人像面失败，失败原因：{}", e.getMessage());
							entity.setIdCardFrontPhotoFlag(3);
							entity.setIdCardFrontPhotoExceptional(e.getMessage());
						}
					}
				}

				// 2.校验身份证国徽面
				if (entity.getIdCardBackPhotoFlag() == 0) {
					// 获取身份证国徽面图片地址
					CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "idCardBack", null);
					if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
						logger.info("获取身份证国徽面图片地址，入参：sourceId-{}，billType-{}", entity.getId(), BILL_TYPE);
					} else {
						List<AttachmentVO> faceAttachmentVOList = response.getData();
						AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);

						try {
							IdentityCardInfoVO identityCardInfoVO = idCardService.checkAndRecognizeIdentityCardInfo(faceAttachmentVO.getTruePath(), "back");
							if (identityCardInfoVO != null) {
								entity.setIdCardBackPhotoFlag(1);
								entity.setIdCardStartDate(identityCardInfoVO.getStartDate());
								entity.setIdCardEndDate(identityCardInfoVO.getEndDate());
								entity.setIdCardIssue(identityCardInfoVO.getIssue());
							}
						} catch (Exception e) {
							logger.info("定时任务，校验身份证国徽面失败，失败原因：{}", e.getMessage());
							entity.setIdCardBackPhotoFlag(3);
							entity.setIdCardBackPhotoExceptional(e.getMessage());
						}
					}
				}

				// 3.校验人脸
				if (entity.getFacePhotoFlag() == 0) {
					// 获取人脸图片地址
					CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "face", null);
					if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
						logger.info("获取人脸图片地址，入参：sourceId-{}，billType-{}", entity.getId(), BILL_TYPE);
					} else {
						List<AttachmentVO> faceAttachmentVOList = response.getData();
						AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);

						FaceInfoVO faceInfoVO = new FaceInfoVO();
						faceInfoVO.setImgUrl(faceAttachmentVO.getTruePath());

						try {
							Boolean faceQualityAndLive = faceService.checkFaceQualityAndLive(faceInfoVO);
							if (Boolean.TRUE.equals(faceQualityAndLive)) {
								entity.setFacePhotoFlag(1);
							}
						} catch (Exception e) {
							logger.info("定时任务，人脸活体校验失败，失败原因：{}", e.getMessage());
							entity.setFacePhotoFlag(3);
							entity.setFacePhotoExceptional(e.getMessage());
						}
					}
				}
			}
			super.updateBatchById(workerEntityList, 100);
		}

		logger.info("定时任务，身份证和人脸校验，end！");
	}

	@Override
	public WorkerVO insertOrUpdate(WorkerVO saveOrUpdateVO) {
		WorkerEntity entity = BeanMapper.map(saveOrUpdateVO, WorkerEntity.class);
		if(entity.getId() == null || entity.getId() == 0){
			BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			if(billCode.isSuccess()) {
				entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			entity.setWorkState(0);
			entity.setEnabled(1);
		}
		List<WorkerRegisterEntity> oldList = new ArrayList<>();
		if(entity.getId()!=null){
			//保存前获取老的中间表班组数据
			LambdaQueryWrapper<WorkerRegisterEntity> oldWrapper = new LambdaQueryWrapper<>();
			oldWrapper.eq(WorkerRegisterEntity::getWorkerId,entity.getId());
			oldWrapper.eq(WorkerRegisterEntity::getDr,0);
			oldList = workerRegisterService.list(oldWrapper);
		}

		super.saveOrUpdate(entity, false);
		//查询当前人员在关系表中是否有数据
		LambdaQueryWrapper<WorkerRegisterEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(WorkerRegisterEntity::getWorkerId,entity.getId());
		List<WorkerRegisterEntity> list = workerRegisterService.list(wrapper);
		//如果没有，则新增关系表数据
		if(CollectionUtils.isEmpty(list)){
			String teamId = entity.getTeamId();
			String[] split = teamId.split(",");
			if(split.length>0){
				for (String s : split) {
					OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(s));
					WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
					workerRegisterEntity.setId(IdWorker.getId());
					workerRegisterEntity.setWorkerId(entity.getId());
					workerRegisterEntity.setTeamId(Long.valueOf(s));
					workerRegisterEntity.setTeamName(teamEntity.getName());
					workerRegisterEntity.setTeamInnerCode(teamEntity.getInnerCode());
					workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
					workerRegisterEntity.setCreateTime(new Date());
					workerRegisterService.save(workerRegisterEntity);
				}
			}
		}else{
			//旧中间表数据
			Map<Long, WorkerRegisterEntity> oldMap = oldList.stream().collect(Collectors.toMap(WorkerRegisterEntity::getTeamId, detailEntity -> detailEntity));
			String teamId = entity.getTeamId();
			String[] split = teamId.split(",");
			List<String> newTeamIds = new ArrayList<>(Arrays.asList(split));
			List<Long> delIds = new ArrayList<>();
			//循环旧数据
			for (Map.Entry<Long, WorkerRegisterEntity> oldEntity : oldMap.entrySet()) {
				int index = newTeamIds.indexOf(String.valueOf(oldEntity.getKey()));
				//判断旧的是否存在新的,如果存在需要移除
				if(index>-1){
					newTeamIds.remove(index);
				}else{
					delIds.add(oldEntity.getValue().getId());
				}
			}
			if(CollectionUtils.isNotEmpty(newTeamIds)){
				//新增
				for (String newTeamId : newTeamIds) {
					OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(newTeamId));
					WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
					workerRegisterEntity.setId(IdWorker.getId());
					workerRegisterEntity.setWorkerId(entity.getId());
					workerRegisterEntity.setTeamId(teamEntity.getId());
					workerRegisterEntity.setTeamName(teamEntity.getName());
					workerRegisterEntity.setTeamInnerCode(teamEntity.getInnerCode());
					workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
					workerRegisterEntity.setCreateTime(new Date());
					workerRegisterService.save(workerRegisterEntity);
				}
			}
			if(CollectionUtils.isNotEmpty(delIds)){
				// 删除关系表数据
				workerRegisterService.removeByIds(delIds,false);
			}

		}
		WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
		return vo;
	}

	@Override
	public IPage<WorkerVO> queryRefOrgTeamPage(Map<String, Object> params) {
		String innerCode = String.valueOf(params.get("innerCode"));
		LambdaQueryWrapper<WorkerRegisterEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.like(WorkerRegisterEntity::getTeamInnerCode,innerCode);
		wrapper.eq(WorkerRegisterEntity::getDr,0);
		//查询内码下的人员班组关系，获取人员
		List<WorkerRegisterEntity> list = workerRegisterService.list(wrapper);
		IPage<WorkerVO> page = new Page<>();
		List<WorkerVO> dataList = new ArrayList<>();
		Long dataCount = 0l;
		if(CollectionUtils.isNotEmpty(list)){
			List<Long> workerIds = list.stream().map(WorkerRegisterEntity::getWorkerId).collect(Collectors.toList());
			params.put("workerIds",workerIds);
			dataList = workerMapper.queryRefOrgTeamList(params);
			dataCount = workerMapper.queryRefOrgTeamCount(params);
		}
		page.setRecords(dataList);
		page.setTotal(dataCount);
		return page;
	}

	@Override
	public WorkerVO updateBatWorker(WorkerVO updateVO) {
		List<Long> ids = updateVO.getIds();//用户ids
		String teamId = updateVO.getTeamId();//所选班组
		String teamName = updateVO.getTeamName();//班组名称
		String workType = updateVO.getWorkType();//所选工种
		String workTypeName = updateVO.getWorkTypeName();//工种名称
		if(CollectionUtils.isNotEmpty(ids)){
			for (Long id : ids) {
				LambdaQueryWrapper<WorkerEntity> queryWapper = new LambdaQueryWrapper<>();
				queryWapper.eq(WorkerEntity::getDr,0);
				queryWapper.eq(WorkerEntity::getId,id);
				//批量修改前查询人员
				List<WorkerEntity> oldWorkerList = super.list(queryWapper);
				List<WorkerRegisterEntity> oldList = new ArrayList<>();
				List<Long> oldIds = oldWorkerList.stream().map(WorkerEntity::getId).collect(Collectors.toList());
				LambdaQueryWrapper<WorkerRegisterEntity> wrWrapper = new LambdaQueryWrapper<>();
				wrWrapper.in(WorkerRegisterEntity::getWorkerId,oldIds);
				wrWrapper.eq(WorkerRegisterEntity::getDr,0);
				//查询修改前人员的关系表数据
				oldList = workerRegisterService.list(wrWrapper);
				//班组或工种不为空才进行修改
				if(teamName!=null || workType!=null){
					LambdaUpdateWrapper<WorkerEntity> wrapper = new LambdaUpdateWrapper<>();
					wrapper.set(teamId!=null,WorkerEntity::getTeamId,teamId);
					wrapper.set(teamId!=null,WorkerEntity::getTeamName,teamName);
					wrapper.set(workType!=null,WorkerEntity::getWorkType,workType);
					wrapper.set(workType!=null,WorkerEntity::getWorkTypeName,workTypeName);
					wrapper.eq(WorkerEntity::getId,id);
					super.update(wrapper);
					//旧中间表数据
					Map<Long, WorkerRegisterEntity> oldMap = oldList.stream().collect(Collectors.toMap(WorkerRegisterEntity::getTeamId, detailEntity -> detailEntity));
					String[] split = teamId.split(",");
					List<String> newTeamIds = new ArrayList<>(Arrays.asList(split));
					List<Long> delIds = new ArrayList<>();
					//循环旧数据
					for (Map.Entry<Long, WorkerRegisterEntity> oldEntity : oldMap.entrySet()) {
						int index = newTeamIds.indexOf(String.valueOf(oldEntity.getKey()));
						//判断旧的是否存在新的,如果存在需要移除
						if(index>-1){
							newTeamIds.remove(index);
						}else{
							delIds.add(oldEntity.getValue().getId());
						}
					}
					if(CollectionUtils.isNotEmpty(newTeamIds)){
						//新增
						for (String newTeamId : newTeamIds) {
							OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(newTeamId));
							WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
							workerRegisterEntity.setId(IdWorker.getId());
							workerRegisterEntity.setWorkerId(id);
							workerRegisterEntity.setTeamId(teamEntity.getId());
							workerRegisterEntity.setTeamName(teamEntity.getName());
							workerRegisterEntity.setTeamInnerCode(teamEntity.getInnerCode());
							workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
							workerRegisterEntity.setCreateTime(new Date());
							workerRegisterService.save(workerRegisterEntity);
						}
					}
					if(CollectionUtils.isNotEmpty(delIds)){
						// 删除关系表数据
						workerRegisterService.removeByIds(delIds,false);
					}
				}
			}
		}
		return updateVO;
	}
}
