package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.labor.mapper.ProjectTeamMapper;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.business.labor.vo.ProjectTeamVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import com.sun.org.apache.bcel.internal.generic.NEW;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.service.IProjectTeamService;

/**
 * 项目班组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTeam")
public class ProjectTeamController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectApi projectApi;
    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";//此处需要根据实际修改

    @Autowired
    private IProjectTeamService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private IWorkerEnterService workerEnterService;
    @RequestMapping(value = "/lazyTeamCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> lazyTeamCategory (Long parentId){
        LambdaQueryWrapper<ProjectTeamEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(parentId != null, ProjectTeamEntity::getParentId,parentId);
        wrapper.eq(ProjectTeamEntity::getTenantId,InvocationInfoProxy.getTenantid());

        List<ProjectTeamEntity> list = service.list(wrapper);
        List<ProjectTeamVO> vos = BeanMapper.mapList(list, ProjectTeamVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            List<Map> resultMapList = BeanMapper.mapList(vos, Map.class);
            for (Map map :resultMapList){
                System.out.println(map);
                if(map.get("isLeaf").equals(false)){
                    map.put("children", new ArrayList<>());
                }
            }
            return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
        }else if (parentId==null){
            //查询本下范围内日的数据
            Long orgId = InvocationInfoProxy.getOrgId();
            List<Map> resultMapList = new ArrayList<>();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                //TODO 没有数据需要插入一条名称为当前根组织的班组
                ProjectTeamEntity entity = new ProjectTeamEntity();
                Long id = IdWorker.getId();
                entity.setId(id);
                entity.setInnerCode(id.toString());
                entity.setIsLeaf(true);
                UserContext userContext = UserContext.getUserContext();
                userContext.getOrgType();
                CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectByProjectDepartmentId(InvocationInfoProxy.getOrgId().toString());
                if(!projectRegisterVOCommonResponse.isSuccess()) {
                    throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
                }
                ProjectRegisterVO project = projectRegisterVOCommonResponse.getData();
                entity.setName(project.getName());
                entity.setProjectId(project.getId());
                entity.setProjectName(project.getName());
                entity.setOrgId(project.getProjectDepartmentId());
                entity.setParentOrgId(project.getOrgId());
                entity.setParentOrgName(project.getOrgName());
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),new OrgTeamVO());
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(!billCode.isSuccess()) {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                service.save(entity);
                List<ProjectTeamEntity> list1 = service.list(wrapper);
                if (CollectionUtils.isNotEmpty(list1)){
                    resultMapList = BeanMapper.mapList(list1, Map.class);
                    resultMapList.forEach(l-> {
                        if(l.get("isLeaf").equals(false)){
                            l.put("children", new ArrayList<>());
                        }
                    });
                }
                return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
            }
        }
        return CommonResponse.success();
    }

    /**
     * 参照异步（懒加载）树----分类树
     * @param condition
     * @param pid
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/lazyTeamTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyTeamTree(@RequestParam(required=false) String condition,
                                                     @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<ProjectTeamVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                dataList = service.queryListTree(params);
            }else{
                dataList = service.queryListByPid(pid);
                if(StringUtils.isNotBlank(condition)){
                    /** 处理condition */
                    JSONObject con = JSONObject.parseObject(condition);
                    Object categoryIdObj = con.get("categoryId");
                    if (null != categoryIdObj && pid == null) {
                        List<Long> asList = new ArrayList<>();
                        String categoryId = ((String) categoryIdObj);
                        if(categoryId.indexOf(",") > 0){
                            String[] strings = categoryId.split(",");
                            for(String str : strings){
                                asList.add(Long.valueOf(str));
                            }
                        }else{
                            asList.add(Long.valueOf(categoryId));
                        }
                        dataList = service.queryCategoryListByIds(asList);
                    }
                }
            }
            List<Map> map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData(map);
        }catch (Exception e){
            return null;
        }
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectTeamVO> saveOrUpdate(@RequestBody ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamVO projectTeamVO = service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",projectTeamVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTeamVO> queryDetail(Long id) {
    	ProjectTeamEntity entity = service.selectById(id);
    	ProjectTeamVO vo = BeanMapper.map(entity, ProjectTeamVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTeamVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectTeamVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectTeamVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询本下所有启用
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryList(@RequestBody QueryParam param) {
        List<JSONObject> jsonObjects = new ArrayList<>();
        //查询本下所有启用、在建的项目，按项目创建时间倒序排列；
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("status",new Parameter(QueryParam.EQ,2));
        param.getParams().put("validStatus",new Parameter(QueryParam.EQ,0));
        CommonResponse<Page<ProjectRegisterVO>> projectResponse = projectApi.queryProjectPage(param);
        if (!projectResponse.isSuccess()){
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectRegisterVO> records = projectResponse.getData().getRecords();
        for (ProjectRegisterVO vo :records){
            JSONObject jsonObject = new JSONObject();
            //查询劳务工数量
            LambdaQueryWrapper<WorkerEnterEntity> workNumLambda =new LambdaQueryWrapper<>();
            workNumLambda.eq(WorkerEnterEntity::getProjectId,vo.getId());
            int workNum = workerEnterService.count(workNumLambda);
            jsonObject.put("workNum",workNum);
            //查询班组数量
            LambdaQueryWrapper<ProjectTeamEntity> teamNumLambda =new LambdaQueryWrapper<>();
            teamNumLambda.eq(ProjectTeamEntity::getProjectId,vo.getId());
            teamNumLambda.isNull(ProjectTeamEntity::getParentId);
            int teamNum = service.count(teamNumLambda);
            jsonObject.put("teamNum",teamNum);
            //查询工种数量：3
            jsonObject.put("workTypeNum",0);
            //查询人脸采集
            LambdaQueryWrapper<WorkerEnterEntity> faceNumLambda =new LambdaQueryWrapper<>();
            faceNumLambda.eq(WorkerEnterEntity::getProjectId,vo.getId());
            faceNumLambda.eq(WorkerEnterEntity::getFacePhotoFlag,1);
            int faceCollection = workerEnterService.count(faceNumLambda);
            jsonObject.put("faceCollection",faceCollection+"/"+workNum);
            String status = "";
//            1-未开工, 2-在建，3-完成
            if (vo.getStatus().equals("1")){
                status="未开工";
            }else if (vo.getStatus().equals("2")){
                status="在建";
            }else {
                status="完成";
            }
            jsonObject.put("status",status);
            //基本信息
            jsonObject.put("id",vo.getId());
            jsonObject.put("name",vo.getName());
            jsonObjects.add(jsonObject);
        }
        IPage<JSONObject> pageData = new Page<>(projectResponse.getData().getCurrent(), projectResponse.getData().getSize(), projectResponse.getData().getTotal());
        pageData.setRecords(jsonObjects);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }





    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectTeamEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectTeam-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectTeamData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectTeamVO>> refProjectTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectTeamEntity> page = service.queryPage(param,false);
        IPage<ProjectTeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTeamVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/insertBatch", method = RequestMethod.POST)
    @ResponseBody
     public CommonResponse<String> insertBatch( @RequestBody List<ProjectTeamVO> vos){
        List<String> strings = service.insertBatch(vos);
        if (strings.size()>0){
            return CommonResponse.error(strings.toString());
        }
        return CommonResponse.success("插入成功");
     }
}
