package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.voms.VOMSAttribute;
import org.checkerframework.checker.units.qual.C;
import org.elasticsearch.common.recycler.Recycler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IWorkRecordService;

/**
 * 用工记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("workRecord")
public class WorkRecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWorkRecordService service;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectApi projectApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkRecordVO> saveOrUpdate(@RequestBody WorkRecordVO saveOrUpdateVO) {
    	WorkRecordEntity entity = BeanMapper.map(saveOrUpdateVO, WorkRecordEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                //entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	WorkRecordVO vo = BeanMapper.map(entity, WorkRecordVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkRecordVO> queryDetail(Long id) {
    	WorkRecordEntity entity = service.selectById(id);
    	WorkRecordVO vo = BeanMapper.map(entity, WorkRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkRecordVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkRecordVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("projectId")&&!param.getParams().containsKey("teamId")){
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        if (param.getParams().containsKey("teamId")){
            fuzzyFields.add("team_id");
            Parameter teamId = param.getParams().get("teamId");
            param.getParams().put("teamId",new Parameter(QueryParam.LIKE,teamId.getValue()));
        }


        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        IPage<WorkRecordEntity> page = service.queryPage(param,false);
        IPage<WorkRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkRecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WorkRecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWorkRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkRecordEntity> page = service.queryPage(param,false);
        IPage<WorkRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkRecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 1、只引入人员：只引入人员信息，如人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
     * 2、引入人员及班组：同时引入人员与班组，当人员对应班组在项目中存在时，则不需要引入，直接挂项目对应班组即可；
     * @param vos
     * @return
     */
    @RequestMapping(value = "/insertWorkRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> insertWorkRecord( @RequestBody List<WorkerVO> vos){
        List<String> errorMsg = new ArrayList<>();
        List<WorkRecordVO> saveVoList = new ArrayList<>();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            //获取项目数据
            CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectByProjectDepartmentId(InvocationInfoProxy.getOrgId().toString());
            if(!projectRegisterVOCommonResponse.isSuccess()) {
                throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
            }
            ProjectRegisterVO project = projectRegisterVOCommonResponse.getData();
            //获取 项目根班组
            QueryWrapper<ProjectTeamEntity> queryProject = new QueryWrapper<>();
            queryProject.eq("project_id",project.getId());
            queryProject.isNull("parent_id");
            ProjectTeamEntity projectTeam = projectTeamService.getOne(queryProject);
            for (WorkerVO vo:vos){
                //TODO 当项目班组中该人员在场的情况下，不可引入
                //查询 当前人员是否存在入场单
                LambdaQueryWrapper<WorkRecordEntity> lambdaCount = new LambdaQueryWrapper<>();
                lambdaCount.eq(WorkRecordEntity::getProjectId,projectTeam.getId());
                lambdaCount.eq(WorkRecordEntity::getPhone,vo.getPhone());
                lambdaCount.eq(WorkRecordEntity::getEnterExitState,1);
                int count = service.count(lambdaCount);
                if (count>0){
                    errorMsg.add("当项目班组中该人员"+ vo.getName()+"在场");
                }else {
                    //TODO 将VO转换为用工记录
                    WorkRecordVO record = BeanMapper.map(vo, WorkRecordVO.class);
                    record.setWorkerId(vo.getId());
                    record.setOrgTeamId(vo.getTeamId());
                    record.setOrgTeamName(vo.getTeamName());
                    record.setOrgWorkType(vo.getWorkType());
                    record.setOrgWorkTypeName(vo.getWorkTypeName());
                    record.setProjectAddress(project.getAddress());
                    record.setSourceFlag(2);
                    record.setSourceId(vo.getId());
                    record.setEnterExitState(1);
                    //设置项目信息
                    record.setProjectId(project.getId());
                    record.setProjectName(project.getName());
                    record.setOrgId(project.getProjectDepartmentId());
                    record.setParentOrgId(project.getOrgId());
                    record.setParentOrgName(project.getOrgName());
                    //TODO 人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
                    if (StringUtils.isNotEmpty(vo.getTeamId())){
                        List<String> teamIdS = Arrays.asList(vo.getTeamId().split(","));
                        //去查询班组是否存在
                        LambdaQueryWrapper<ProjectTeamEntity> teamLambda = new LambdaQueryWrapper<>();
                        teamLambda.eq(ProjectTeamEntity::getProjectId,project.getId());
                        teamLambda.in(ProjectTeamEntity::getId,teamIdS);
                        teamLambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
                        List<ProjectTeamEntity> list = projectTeamService.list(teamLambda);
                        if (CollectionUtils.isNotEmpty(list)){
                            String teamId = list.stream().map(ProjectTeamEntity::getId).collect(Collectors.toList()).
                                    stream().map(Objects::toString).collect(Collectors.joining(","));
                            String teamName = list.stream().map(ProjectTeamEntity::getName).collect(Collectors.toList()).
                                    stream().map(Objects::toString).collect(Collectors.joining(","));
                            record.setTeamId(teamId);
                            record.setTeamName(teamName);
                        }else {
                            record.setTeamId(null);
                            record.setTeamName(null);
                        }
                    }

                    saveVoList.add(record);
                }
            }
            if (CollectionUtils.isNotEmpty(saveVoList)){
                //TODO 保存 推送数据到用工记录单
                service.insertWorkRecord(saveVoList);
            }
        }else {
            errorMsg.add("当前登录不是项目部!");
        }
        if (errorMsg.size()>0){
            return CommonResponse.error(errorMsg.toString());
        }
        return CommonResponse.success("插入成功");
    }

}
