package com.ejianc.business.labor.controller;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.utils.WagesTypeEnum;
import com.ejianc.business.labor.vo.CustomValidateGroup;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公司花名册人员
 *
 * @author generator
 *
 */
@Validated
@RestController
@RequestMapping("worker")
public class WorkerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWorkerService service;

    @Autowired
    private IOrgTeamService orgTeamService;

    @Autowired
    private IWorkerRegisterService workerRegisterService;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private SessionManager sessionManager;

    @Resource
    private IIdCardService iIdCardService;

    @Resource
    private IFaceService faceService;

    private static final String BILL_CODE = "LABOR_WORKER";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> saveOrUpdate(@RequestBody WorkerVO saveOrUpdateVO) {
        LambdaQueryWrapper<WorkerEntity> idCardQueryWrapper = new LambdaQueryWrapper<>();
        idCardQueryWrapper.eq(WorkerEntity::getIdCard,saveOrUpdateVO.getIdCard());
        idCardQueryWrapper.eq(WorkerEntity::getDr,0);
        idCardQueryWrapper.ne(saveOrUpdateVO.getId()!=null,WorkerEntity :: getId,saveOrUpdateVO.getId());
        List<WorkerEntity> idCardList = service.list(idCardQueryWrapper);
        LambdaQueryWrapper<WorkerEntity> phoneQueryWrapper = new LambdaQueryWrapper<>();
        phoneQueryWrapper.eq(WorkerEntity::getPhone,saveOrUpdateVO.getPhone());
        phoneQueryWrapper.eq(WorkerEntity::getDr,0);
        phoneQueryWrapper.ne(saveOrUpdateVO.getId()!=null,WorkerEntity :: getId,saveOrUpdateVO.getId());
        List<WorkerEntity> phoneList = service.list(phoneQueryWrapper);
        if(CollectionUtils.isNotEmpty(idCardList)){
            return CommonResponse.error("保存或修改单据失败，身份证已存在");
        }else if(CollectionUtils.isNotEmpty(phoneList)) {
            return CommonResponse.error("保存或修改单据失败，手机号已存在");
        }else{
            WorkerVO vo = service.insertOrUpdate(saveOrUpdateVO);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }
    }

    /**
     *  批量修改人员的班组和工种
     * @param updateVO
     * @return
     */
    @RequestMapping(value = "/updateBatWorker", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> updateBatWorker(@RequestBody WorkerVO updateVO){
        WorkerVO vo = service.updateBatWorker(updateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkerVO> queryDetail(Long id) {
    	WorkerEntity entity = service.selectById(id);
    	WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> delIds = vos.stream().map(WorkerVO::getId).collect(Collectors.toList());
        service.removeByIds(delIds,true);
        //删除成功后，同时删除该人员在中间表的数据
        LambdaUpdateWrapper<WorkerRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(WorkerRegisterEntity::getDr,1);
        updateWrapper.in(WorkerRegisterEntity::getWorkerId,delIds);
        workerRegisterService.update(updateWrapper);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> params = param.getParams();
        if(params.containsKey("teamId")){
            Object teamId = params.get("teamId").getValue();
            LambdaQueryWrapper<WorkerRegisterEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.like(WorkerRegisterEntity::getTeamInnerCode,String.valueOf(teamId));
            List<WorkerRegisterEntity> list = workerRegisterService.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                param.getParams().put("id",new Parameter(QueryParam.IN,list.stream().map(WorkerRegisterEntity::getWorkerId).collect(Collectors.toList())));
                param.getParams().remove("teamId");
            }
        }

        IPage<WorkerEntity> page = service.queryPage(param,false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Worker-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPersonTemplet")
    @ResponseBody
    public void downloadPersonTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "WorkerImport-export.xlsx", "零星用工内容导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportPerson", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportPerson(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<WorkerVO> successList = new ArrayList<>();
            List<WorkerVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 15) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }
            List<String> idCardList = new ArrayList<>();
            List<String> phoneList = new ArrayList<>();
            for (int i = 0; i < result.size(); i++) {
                // 开始判断逻辑
                WorkerVO workerVO = new WorkerVO();
                List<String> datas = result.get(i);
                //姓名
                String name = datas.get(0).trim();
                if(name != null && !"".equals(name)){
                    workerVO.setName(name);
                }else{
                    workerVO.setErrorMessage("姓名为空");
                }
                //身份证号
                String idCard = datas.get(1).trim();
                if(idCard != null){
                    workerVO.setIdCard(idCard);
                    if(idCardList.indexOf(idCard) == -1){
                        LambdaQueryWrapper<WorkerEntity> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(WorkerEntity::getIdCard,idCard);
                        wrapper.eq(WorkerEntity::getDr,0);
                        List<WorkerEntity> list = service.list(wrapper);
                        if(CollectionUtils.isNotEmpty(list)){
                            workerVO.setErrorMessage("公司花名册已存在该人员");
                        }
                    }else{
                        workerVO.setErrorMessage(i+"行身份证号重复");
                    }
                }else{
                    workerVO.setErrorMessage("身份证号为空");
                }
                //出生日期
                String birthDate = datas.get(2).trim();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if(birthDate != null && !"".equals(birthDate)){
                    try {
                        Date parse = sdf.parse(birthDate);
                        workerVO.setBirthDate(parse);
                    } catch (ParseException e) {
                        e.printStackTrace();
                        workerVO.setErrorMessage("日期格式有误");
                    }
                }
                //性别
                String sex = datas.get(3).trim();
                if(sex != null){
                    if("男".equals(sex)){
                        workerVO.setSex(1);//ses 1-男，2-女
                        workerVO.setSexName("男");
                    }else{
                        workerVO.setSex(2);//ses 1-男，2-女
                        workerVO.setSexName("女");
                    }
                }
                //民族
                String nation = datas.get(4).trim();
                workerVO.setNation(nation);
                //所属班组
                String teamName = datas.get(5).trim();
                if(teamName!=null  && !"".equals(teamName)){
                    LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(OrgTeamEntity::getName,teamName);
                    //根据名称匹配
                    List<OrgTeamEntity> list = orgTeamService.list(wrapper);
                    if(CollectionUtils.isNotEmpty(list)){
                        workerVO.setTeamId(String.valueOf(list.get(0).getId()));
                        workerVO.setTeamName(list.get(0).getName());
                    }
                }
                //工种
                String workType = datas.get(6).trim();
                if(workType != null && !"".equals(workType)){
                    //获取工种的档案
                    CommonResponse<List<DefdocDetailVO>> workerTypeListRes = defdocApi.getDefDocByDefCode("labor_worker_type");
                    if(workerTypeListRes.isSuccess()){
                        List<DefdocDetailVO> workerTypeList = workerTypeListRes.getData();
                        for (DefdocDetailVO defdocDetailVO : workerTypeList) {
                            if(defdocDetailVO.getName().equals(workType)){
                                workerVO.setWorkType(String.valueOf(defdocDetailVO.getId()));
                                workerVO.setWorkTypeName(defdocDetailVO.getName());
                            }
                        }
                    }else{
                        workerVO.setErrorMessage("工种查询失败");
                    }
                }
                //手机号
                String phone = datas.get(7).trim();
                if(phone != null && !"".equals(phone)){
                    workerVO.setPhone(phone);
                    if(phoneList.indexOf(phone) == -1){
                        LambdaQueryWrapper<WorkerEntity> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(WorkerEntity::getPhone,phone);
                        wrapper.eq(WorkerEntity::getDr,0);
                        List<WorkerEntity> list = service.list(wrapper);
                        if(CollectionUtils.isNotEmpty(list)){
                            workerVO.setErrorMessage("公司花名册已存在手机号");
                        }
                    }else{
                        workerVO.setErrorMessage(i+"行手机号重复");
                    }
                }
                //开户行
                String bankName = datas.get(8).trim();
                workerVO.setBankName(bankName);
                //银行账号
                String bankAccount = datas.get(9).trim();
                workerVO.setBankAccount(bankAccount);
                //工资类型
                String wagesType = datas.get(10).trim();
                if(wagesType != null && !"".equals(wagesType)){
                    if(WagesTypeEnum.HOUR.getName().equals(wagesType)){
                        workerVO.setWagesType(WagesTypeEnum.HOUR.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.HOUR.getName());
                    }
                    if(WagesTypeEnum.DAY.getName().equals(wagesType)){
                        workerVO.setWagesType(WagesTypeEnum.DAY.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.DAY.getName());
                    }
                    if(WagesTypeEnum.MONTH.getName().equals(wagesType)){
                        workerVO.setWagesType(WagesTypeEnum.MONTH.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.MONTH.getName());
                    }
                    if(WagesTypeEnum.QUANT.getName().equals(wagesType)){
                        workerVO.setWagesType(WagesTypeEnum.QUANT.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.QUANT.getName());
                    }
                }
                //工价
                String wage = datas.get(11).trim();
                if(wage != null && !"".equals(wage)){
                    workerVO.setWage(new BigDecimal(wage));
                }
                //所属地区
                String area = datas.get(12).trim();
                if(area != null && !"".equals(area)){
                    Map<String,Object> map = service.getArea(area);
                    if(map.get("province")!=null){
                        workerVO.setProvince(String.valueOf(map.get("province")));
                    }
                    if(map.get("city")!=null){
                        workerVO.setCity(String.valueOf(map.get("city")));
                    }
                    if(map.get("area")!=null){
                        workerVO.setArea(String.valueOf(map.get("area")));
                    }
                }
                //居住地址
                String address = datas.get(13).trim();
                workerVO.setAddress(address);
                //备注
                String memo = datas.get(14).trim();
                workerVO.setMemo(memo);

                if (StringUtils.isBlank(workerVO.getErrorMessage())) {
                    successList.add(workerVO);
                }else{
                    errorList.add(workerVO);
                }
                workerVO.setSourceFlag(1);
                workerVO.setSourceFlagName("公司自制");
                //当前导入人员无错误信息时，新增
                if(workerVO.getErrorMessage()==null){
                    service.insertOrUpdate(workerVO);
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * 分页查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "refWorkerPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                         @RequestParam(required = false) String relyCondition,
                                                         @RequestParam(required = false) String searchText,
                                                         @RequestParam(required = false) String condition,
                                                         @RequestParam(required = false) String searchObject) {
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            OrgTeamEntity orgTeam = orgTeamService.getById(categoryId);
            if (orgTeam != null) {
                params.put("innerCode", orgTeam.getInnerCode());
            }else{
                return CommonResponse.error("当前班组不存在档案！");
            }
        }
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("categoryCode") != null) {
                params.put("categoryCode", search.get("categoryCode").toString());
            }
            if (search.get("categoryName") != null) {
                params.put("categoryName", search.get("categoryName").toString());
            }
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<WorkerVO> pageData = service.queryRefOrgTeamPage(params);
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);
        return CommonResponse.success("查询成功！", pageData);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkerEntity> page = service.queryPage(param, false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 校验身份证以及身份证信息识别
     *
     * @param imageUrl 身份证阿里oss存储在线地址
     * @param side     face：人像面  back：国徽面
     *
     * @return {@link CommonResponse}<{@link IdentityCardInfoVO}>
     */
    @GetMapping(value = "checkAndRecognizeIdentityCardInfo")
    public CommonResponse<IdentityCardInfoVO> checkAndRecognizeIdentityCardInfo(@RequestParam(value = "imageUrl") String imageUrl,
                                                                                @RequestParam(value = "side") String side) {
        return CommonResponse.success("校验身份证以及身份证信息识别，成功！", iIdCardService.checkAndRecognizeIdentityCardInfo(imageUrl, side));
    }

    /**
     * 人脸活体校验
     *
     * @param faceInfoVO 人脸信息VO
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @PostMapping(value = "checkFaceQualityAndLive")
    public CommonResponse<Boolean> checkFaceQualityAndLive(@Validated(value = {CustomValidateGroup.Crud.Create.class}) @RequestBody FaceInfoVO faceInfoVO) {
        return CommonResponse.success("人脸活体校验，成功！", faceService.checkFaceQualityAndLive(faceInfoVO));
    }

    /**
     * 公司花名册人员身份证和人脸校验定时任务
     *
     * @param request 请求
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @PostMapping(value = "/checkTask")
    public CommonResponse<Void> checkTask(HttpServletRequest request) {
        service.checkTask(request);
        return CommonResponse.success("定时任务，身份证和人脸校验执行成功！");
    }

    /**
     * 下载导入证件模版
     *
     * @param request  请求
     * @param response 响应
     */
    @PostMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClassPathResource resource = new ClassPathResource("zip/导入证件.zip");
        InputStream inputStream = resource.getInputStream();

        response.reset();
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("导入证件.zip", "utf-8"));
        response.setContentType("application/octet-stream;charset=UTF-8");
        IoUtil.copy(inputStream, response.getOutputStream());
    }


    /**
     * 批量校验证件
     *
     * @param request  请求
     * @param response 响应
     *
     * @return {@link CommonResponse}<{@link JSONObject}>
     */
    @PostMapping(value = "batchCheck")
    public CommonResponse<JSONObject> batchCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return CommonResponse.success("", service.batchCheck(request, response));
    }

}
