package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * 公司花名册人员
 *
 * @author generator
 */
public interface IWorkerService extends IBaseService<WorkerEntity> {

	/**
	 * 公司花名册人员身份证和人脸校验定时任务
	 *
	 * @param request 请求
	 */
	void checkTask(HttpServletRequest request);

	WorkerVO insertOrUpdate(WorkerVO vo);

	IPage<WorkerVO> queryRefOrgTeamPage(Map<String, Object> params);

	WorkerVO updateBatWorker(WorkerVO updateVO);

	Map<String, Object> getArea(String area);

	/**
	 * 批量校验证件
	 *
	 * @param request  请求
	 * @param response 响应
	 *
	 * @return {@link JSONObject}
	 */
	JSONObject batchCheck(HttpServletRequest request, HttpServletResponse response) throws IOException;
}
