package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.OrgTeamMapper;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.service.IOrgTeamService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公司花名册班组
 * 
 * @author generator
 * 
 */
@Service("orgTeamService")
public class OrgTeamServiceImpl extends BaseServiceImpl<OrgTeamMapper, OrgTeamEntity> implements IOrgTeamService{

    @Autowired
    private OrgTeamMapper orgTeamMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LABOR_ORG_TEAM";//此处需要根据实际修改

    @Override
    public List<OrgTeamVO> queryListTree(Map<String, Object> params) {
        List<OrgTeamVO> orgTeamList = orgTeamMapper.queryListTree(params);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<OrgTeamVO> orgTeamList =  orgTeamMapper.queryListByPid(tenantId, id);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryCategoryListByIds(List<Long> ids) {
        Map<String, Object> params = new HashMap<>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<OrgTeamVO> orgTeamList =  orgTeamMapper.queryListByIds(params);
        return orgTeamList;
    }

    @Override
    public OrgTeamVO insertOrUpdate(OrgTeamVO saveOrUpdateVO) {
        OrgTeamEntity entity = BeanMapper.map(saveOrUpdateVO, OrgTeamEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setIsLeaf(true);
        super.saveOrUpdate(entity, false);
        Long parentId = entity.getParentId();
        //当前新增的父级不为空时，设置父级的isLeaf字段为非叶子节点
        LambdaUpdateWrapper<OrgTeamEntity> wrapper = new LambdaUpdateWrapper<>();
        if(parentId!=null){
            //修改父级的是否叶子节点字段
            wrapper.set(OrgTeamEntity::getIsLeaf,false);
            wrapper.eq(OrgTeamEntity::getId,parentId);
            //修改当前节点的内码
            OrgTeamEntity parentEntity = super.selectById(entity.getParentId());
            String innerCode = parentEntity.getInnerCode()+"|"+entity.getId();
            LambdaUpdateWrapper<OrgTeamEntity> curWrapper = new LambdaUpdateWrapper<>();
            curWrapper.set(OrgTeamEntity::getInnerCode,innerCode);
            curWrapper.eq(OrgTeamEntity::getId,entity.getId());
            super.update(curWrapper);
        }else{
            wrapper.set(OrgTeamEntity::getInnerCode,entity.getId().toString());
        }
        super.update(wrapper);
        OrgTeamVO vo = BeanMapper.map(entity, OrgTeamVO.class);
        return vo;
    }

}
